/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.model.impl.SourceElement;

public abstract class SourceConstruct
extends SourceElement
implements ISourceConstruct {
    private int occurrenceCount = 1;

    public SourceConstruct(Handle parent, String name) {
        super(parent, name);
        if (parent == null) {
            throw new IllegalArgumentException();
        }
    }

    public final int getOccurenceCount() {
        return this.occurrenceCount;
    }

    public final void incrementOccurenceCount() {
        ++this.occurrenceCount;
    }

    @Override
    public final IResource getResource() {
        return this.parent.getResource();
    }

    @Override
    public final boolean exists() {
        try {
            this.getBody();
            return true;
        }
        catch (CoreException e) {
            return false;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SourceConstruct)) {
            return false;
        }
        return super.equals(obj) && this.occurrenceCount == ((SourceConstruct)obj).occurrenceCount;
    }

    @Override
    public final boolean close() {
        throw new AssertionError((Object)"This method should not be called");
    }

    @Override
    protected final void validateExistence() throws CoreException {
        throw new AssertionError((Object)"This method should not be called");
    }

    @Override
    protected final Body newBody() {
        return null;
    }

    @Override
    protected final Handle getOpenableParent() {
        Handle result = this.parent;
        while (result instanceof SourceConstruct) {
            result = result.parent;
        }
        return result;
    }

    @Override
    protected final void buildStructure(Body body, Map<IHandle, Body> newElements) throws CoreException {
        throw new AssertionError((Object)"This method should not be called");
    }

    @Override
    protected void toStringName(StringBuilder builder) {
        super.toStringName(builder);
        if (this.occurrenceCount > 1) {
            builder.append('#');
            builder.append(this.occurrenceCount);
        }
    }
}

