/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import org.eclipse.handly.util.LruCache;

public abstract class OverflowingLruCache<K, V>
extends LruCache<K, V> {
    protected int overflow = 0;
    protected boolean timestampsOn = true;
    protected double loadFactor = 0.333;

    public OverflowingLruCache(int size) {
        this(size, 0);
    }

    public OverflowingLruCache(int size, int overflow) {
        super(size);
        this.overflow = overflow;
    }

    @Override
    public Object clone() {
        OverflowingLruCache newCache = this.newInstance(this.spaceLimit, this.overflow);
        LruCache.LruCacheEntry qEntry = this.entryQueueTail;
        while (qEntry != null) {
            newCache.privateAdd(qEntry.key, qEntry.value, qEntry.space);
            qEntry = qEntry.previous;
        }
        return newCache;
    }

    @Override
    public V put(K key, V value) {
        if (this.overflow > 0) {
            this.shrink();
        }
        int newSpace = this.spaceFor(value);
        LruCache.LruCacheEntry entry = (LruCache.LruCacheEntry)this.entryTable.get(key);
        if (entry != null) {
            int oldSpace = entry.space;
            int newTotal = this.currentSpace - oldSpace + newSpace;
            if (newTotal <= this.spaceLimit) {
                this.updateTimestamp(entry);
                entry.value = value;
                entry.space = newSpace;
                this.currentSpace = newTotal;
                this.overflow = 0;
                return value;
            }
            this.privateRemoveEntry(entry, false, false);
        }
        this.makeSpace(newSpace);
        this.privateAdd(key, value, newSpace);
        return value;
    }

    public boolean shrink() {
        if (this.overflow > 0) {
            return this.makeSpace(0);
        }
        return true;
    }

    @Override
    public double fillingRatio() {
        return (double)(this.currentSpace + this.overflow) * 100.0 / (double)this.spaceLimit;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public double getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(double newLoadFactor) throws IllegalArgumentException {
        if (!(newLoadFactor <= 1.0) || !(newLoadFactor > 0.0)) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = newLoadFactor;
    }

    @Override
    public void setSpaceLimit(int limit) {
        if (limit < this.spaceLimit) {
            this.makeSpace(this.spaceLimit - limit);
        }
        this.spaceLimit = limit;
    }

    @Override
    public String toString() {
        return String.valueOf(this.toStringFillingRation("OverflowingLruCache")) + this.toStringContents();
    }

    protected abstract boolean close(LruCache.LruCacheEntry<K, V> var1);

    protected abstract OverflowingLruCache<K, V> newInstance(int var1, int var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean makeSpace(int space) {
        int limit = this.spaceLimit;
        if (this.overflow == 0 && this.currentSpace + space <= limit) {
            return true;
        }
        int spaceNeeded = (int)((1.0 - this.loadFactor) * (double)limit);
        spaceNeeded = spaceNeeded > space ? spaceNeeded : space;
        LruCache.LruCacheEntry entry = this.entryQueueTail;
        try {
            this.timestampsOn = false;
            while (this.currentSpace + spaceNeeded > limit && entry != null) {
                this.privateRemoveEntry(entry, false, false);
                entry = entry.previous;
            }
        }
        finally {
            this.timestampsOn = true;
        }
        if (this.currentSpace + space <= limit) {
            this.overflow = 0;
            return true;
        }
        this.overflow = this.currentSpace + space - limit;
        return false;
    }

    @Override
    protected void privateRemoveEntry(LruCache.LruCacheEntry<K, V> entry, boolean shuffle) {
        this.privateRemoveEntry(entry, shuffle, true);
    }

    protected void privateRemoveEntry(LruCache.LruCacheEntry<K, V> entry, boolean shuffle, boolean external) {
        if (!shuffle) {
            if (external) {
                this.entryTable.remove(entry.key);
                this.currentSpace -= entry.space;
            } else {
                if (!this.close(entry)) {
                    return;
                }
                if (this.entryTable.get(entry.key) == null) {
                    return;
                }
                this.entryTable.remove(entry.key);
                this.currentSpace -= entry.space;
            }
        }
        LruCache.LruCacheEntry previous = entry.previous;
        LruCache.LruCacheEntry next = entry.next;
        if (previous == null) {
            this.entryQueue = next;
        } else {
            previous.next = next;
        }
        if (next == null) {
            this.entryQueueTail = previous;
        } else {
            next.previous = previous;
        }
    }

    @Override
    protected void updateTimestamp(LruCache.LruCacheEntry<K, V> entry) {
        if (this.timestampsOn) {
            entry.timestamp = this.timestampCounter++;
            if (this.entryQueue != entry) {
                this.privateRemoveEntry(entry, true);
                this.privateAddEntry(entry, true);
            }
        }
    }
}

