/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.examples.basic.ui.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.handly.examples.basic.ui.model.IFooElement;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooModel;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.internal.examples.basic.ui.model.FooModelManager;

public class FooModelCore {
    public static IFooModel getFooModel() {
        return FooModelManager.INSTANCE.getFooModel();
    }

    public static IFooFile create(IFile file) {
        if (file == null) {
            return null;
        }
        if (file.getParent().getType() != 4) {
            return null;
        }
        IFooProject project = FooModelCore.create(file.getProject());
        return project.getFooFile(file.getName());
    }

    public static IFooProject create(IProject project) {
        if (project == null) {
            return null;
        }
        return FooModelCore.getFooModel().getFooProject(project.getName());
    }

    public static IFooElement create(IResource resource) {
        if (resource == null) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return FooModelCore.create((IProject)resource);
            }
            case 1: {
                return FooModelCore.create((IFile)resource);
            }
            case 8: {
                return FooModelCore.getFooModel();
            }
        }
        return null;
    }

    private FooModelCore() {
    }
}

