/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.internal.examples.basic.ui.Activator;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.util.TextRange;
import org.eclipse.ui.texteditor.ITextEditor;

public class SourceElementUtil {
    public static ISourceElement getElementAt(ISourceElement element, int position) {
        ISourceFile sourceFile = element instanceof ISourceFile ? (ISourceFile)element : (ISourceFile)element.getAncestor(ISourceFile.class);
        if (sourceFile != null) {
            try {
                sourceFile.reconcile(false, null);
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
                return null;
            }
        }
        return element.getElementAt(position, null);
    }

    public static boolean revealInTextEditor(ITextEditor textEditor, ISourceElement element) {
        ISourceElementInfo info;
        try {
            info = element.getSourceElementInfo();
        }
        catch (CoreException e) {
            if (element.exists()) {
                Activator.log(e.getStatus());
            }
            return false;
        }
        TextRange identifyingRange = info.getIdentifyingRange();
        if (identifyingRange == null) {
            return false;
        }
        textEditor.selectAndReveal(identifyingRange.getOffset(), identifyingRange.getLength());
        return true;
    }

    private SourceElementUtil() {
    }
}

