/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.text.reconciler;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class CompositeReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private IReconcilingStrategy[] strategies;

    public CompositeReconcilingStrategy(IReconcilingStrategy ... strategies) {
        IReconcilingStrategy[] iReconcilingStrategyArray = strategies;
        int n = strategies.length;
        int n2 = 0;
        while (n2 < n) {
            IReconcilingStrategy strategy = iReconcilingStrategyArray[n2];
            if (strategy == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        this.strategies = strategies;
    }

    public void setDocument(IDocument document) {
        IReconcilingStrategy[] iReconcilingStrategyArray = this.strategies;
        int n = this.strategies.length;
        int n2 = 0;
        while (n2 < n) {
            IReconcilingStrategy strategy = iReconcilingStrategyArray[n2];
            strategy.setDocument(document);
            ++n2;
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        IReconcilingStrategy[] iReconcilingStrategyArray = this.strategies;
        int n = this.strategies.length;
        int n2 = 0;
        while (n2 < n) {
            IReconcilingStrategy strategy = iReconcilingStrategyArray[n2];
            strategy.reconcile(dirtyRegion, subRegion);
            ++n2;
        }
    }

    public void reconcile(IRegion partition) {
        IReconcilingStrategy[] iReconcilingStrategyArray = this.strategies;
        int n = this.strategies.length;
        int n2 = 0;
        while (n2 < n) {
            IReconcilingStrategy strategy = iReconcilingStrategyArray[n2];
            strategy.reconcile(partition);
            ++n2;
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        IReconcilingStrategy[] iReconcilingStrategyArray = this.strategies;
        int n = this.strategies.length;
        int n2 = 0;
        while (n2 < n) {
            IReconcilingStrategy strategy = iReconcilingStrategyArray[n2];
            if (strategy instanceof IReconcilingStrategyExtension) {
                IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)strategy;
                extension.setProgressMonitor(monitor);
            }
            ++n2;
        }
    }

    public void initialReconcile() {
        IReconcilingStrategy[] iReconcilingStrategyArray = this.strategies;
        int n = this.strategies.length;
        int n2 = 0;
        while (n2 < n) {
            IReconcilingStrategy strategy = iReconcilingStrategyArray[n2];
            if (strategy instanceof IReconcilingStrategyExtension) {
                IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)strategy;
                extension.initialReconcile();
            }
            ++n2;
        }
    }
}

