/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.viewer;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.ui.viewer.ProblemLabelDecorator;
import org.eclipse.handly.util.TextRange;

public class ProblemMarkerLabelDecorator
extends ProblemLabelDecorator {
    @Override
    protected ProblemLabelDecorator.Severity computeProblemSeverity(Object element) {
        try {
            return this.computeProblemSeverityFromMarkers(element);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() != 376) {
                Activator.log(e.getStatus());
            }
            return null;
        }
    }

    protected ProblemLabelDecorator.Severity computeProblemSeverityFromMarkers(Object element) throws CoreException {
        IResource resource = null;
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IHandle) {
            resource = ((IHandle)element).getResource();
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            resource = (IResource)adaptable.getAdapter(IResource.class);
        }
        if (resource == null || !resource.isAccessible()) {
            return null;
        }
        TextRange textRange = null;
        if (element instanceof ISourceConstruct) {
            ISourceConstruct sourceConstruct = (ISourceConstruct)element;
            if (!sourceConstruct.exists()) {
                return null;
            }
            textRange = sourceConstruct.getSourceElementInfo().getFullRange();
            if (textRange == null) {
                return null;
            }
        }
        return ProblemMarkerLabelDecorator.findMaxProblemSeverity(resource, 2, textRange);
    }

    protected static ProblemLabelDecorator.Severity findMaxProblemSeverity(IResource resource, int depth, TextRange textRange) throws CoreException {
        int severity = 0;
        if (textRange == null) {
            severity = resource.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, depth);
        } else {
            IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
            if (markers != null) {
                int i = 0;
                while (i < markers.length && severity != 2) {
                    int val;
                    IMarker marker = markers[i];
                    if (ProblemMarkerLabelDecorator.isMarkerInRange(marker, textRange) && ((val = marker.getAttribute("severity", -1)) == 1 || val == 2)) {
                        severity = val;
                    }
                    ++i;
                }
            }
        }
        if (severity == 2) {
            return ProblemLabelDecorator.Severity.ERROR;
        }
        if (severity == 1) {
            return ProblemLabelDecorator.Severity.WARNING;
        }
        return null;
    }

    private static boolean isMarkerInRange(IMarker marker, TextRange textRange) {
        int position = marker.getAttribute("charStart", -1);
        return textRange.strictlyCovers(position);
    }
}

