/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.handly.buffer.IDocumentBuffer;
import org.eclipse.handly.internal.xtext.ui.Activator;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.ISourceFileFactory;
import org.eclipse.handly.model.impl.IWorkingCopyBuffer;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.ui.IElementForEditorInputFactory;
import org.eclipse.handly.ui.texteditor.TextEditorBuffer;
import org.eclipse.handly.util.TextRange;
import org.eclipse.handly.xtext.ui.editor.XtextWorkingCopyBuffer;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.ui.editor.IXtextEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class HandlyXtextEditorCallback
extends IXtextEditorCallback.NullImpl {
    @Inject(optional=true)
    private IElementForEditorInputFactory inputElementFactory;
    @Inject(optional=true)
    private ISourceFileFactory sourceFileFactory;
    private Map<XtextEditor, SourceFile> workingCopies = new HashMap<XtextEditor, SourceFile>();
    private Map<XtextEditor, ISelectionChangedListener> selectionListeners = new HashMap<XtextEditor, ISelectionChangedListener>();
    private Map<XtextEditor, HighlightRangeJob> highlightRangeJobs = new HashMap<XtextEditor, HighlightRangeJob>();

    @Inject
    void init() {
        if (this.inputElementFactory == null) {
            if (this.sourceFileFactory == null) {
                throw new AssertionError((Object)"No implementation for IElementForEditorInputFactory or ISourceFileFactory was bound");
            }
            this.inputElementFactory = new IElementForEditorInputFactory(){

                public IHandle getElement(IEditorInput input) {
                    if (input == null) {
                        return null;
                    }
                    IFile file = (IFile)input.getAdapter(IFile.class);
                    if (file == null) {
                        return null;
                    }
                    ISourceFile sourceFile = HandlyXtextEditorCallback.this.sourceFileFactory.getSourceFile(file);
                    return sourceFile;
                }
            };
        }
    }

    public void afterCreatePartControl(XtextEditor editor) {
        this.setHighlightRange(editor, editor.getSelectionProvider().getSelection());
        this.registerSelectionListener(editor);
    }

    public void beforeDispose(XtextEditor editor) {
        this.deregisterSelectionListener(editor);
        this.discardWorkingCopy(editor);
        this.disposeHighlightRangeJob(editor);
    }

    public void beforeSetInput(XtextEditor editor) {
        this.discardWorkingCopy(editor);
    }

    public void afterSetInput(XtextEditor editor) {
        this.createWorkingCopy(editor);
        this.setHighlightRange(editor, editor.getSelectionProvider().getSelection());
    }

    protected void afterSelectionChange(XtextEditor editor, ISelection selection) {
        this.setHighlightRange(editor, selection);
    }

    protected void setHighlightRange(XtextEditor editor, ISelection selection) {
        if (selection == null) {
            return;
        }
        SourceFile sourceFile = this.getWorkingCopy(editor);
        if (sourceFile == null) {
            return;
        }
        this.scheduleHighlightRangeJob(editor, sourceFile, selection);
    }

    protected SourceFile getSourceFile(XtextEditor editor) {
        IHandle inputElement = this.inputElementFactory.getElement(editor.getEditorInput());
        if (!(inputElement instanceof SourceFile)) {
            return null;
        }
        return (SourceFile)inputElement;
    }

    protected final SourceFile getWorkingCopy(XtextEditor editor) {
        return this.workingCopies.get(editor);
    }

    private void registerSelectionListener(final XtextEditor editor) {
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HandlyXtextEditorCallback.this.afterSelectionChange(editor, event.getSelection());
            }
        };
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(listener);
        } else {
            selectionProvider.addSelectionChangedListener(listener);
        }
        this.selectionListeners.put(editor, listener);
    }

    private void deregisterSelectionListener(XtextEditor editor) {
        ISelectionChangedListener listener = this.selectionListeners.remove(editor);
        if (listener != null) {
            ISelectionProvider selectionProvider = editor.getSelectionProvider();
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(listener);
            } else {
                selectionProvider.removeSelectionChangedListener(listener);
            }
        }
    }

    private void createWorkingCopy(XtextEditor editor) {
        SourceFile sourceFile = this.getSourceFile(editor);
        if (sourceFile != null && !sourceFile.isWorkingCopy() && sourceFile.getParent().exists()) {
            try {
                XtextWorkingCopyBuffer buffer = new XtextWorkingCopyBuffer(sourceFile, (IDocumentBuffer)new TextEditorBuffer((ITextEditor)editor));
                try {
                    sourceFile.becomeWorkingCopy((IWorkingCopyBuffer)buffer, null);
                    this.workingCopies.put(editor, sourceFile);
                }
                finally {
                    buffer.dispose();
                }
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
        }
    }

    private void discardWorkingCopy(XtextEditor editor) {
        SourceFile sourceFile = this.workingCopies.remove(editor);
        if (sourceFile != null) {
            sourceFile.discardWorkingCopy();
        }
    }

    private void scheduleHighlightRangeJob(XtextEditor editor, SourceFile sourceFile, ISelection selection) {
        HighlightRangeJob highlightRangeJob = this.highlightRangeJobs.get(editor);
        if (highlightRangeJob == null) {
            highlightRangeJob = new HighlightRangeJob(editor);
            this.highlightRangeJobs.put(editor, highlightRangeJob);
        }
        highlightRangeJob.cancel();
        highlightRangeJob.setArgs(new HighlightArgs(sourceFile, selection));
        highlightRangeJob.schedule();
    }

    private void disposeHighlightRangeJob(XtextEditor editor) {
        HighlightRangeJob highlightRangeJob = this.highlightRangeJobs.remove(editor);
        if (highlightRangeJob != null) {
            highlightRangeJob.cancel();
            highlightRangeJob.setArgs(null);
        }
    }

    private static class HighlightArgs {
        public final SourceFile sourceFile;
        public final ISelection selection;

        public HighlightArgs(SourceFile sourceFile, ISelection selection) {
            this.sourceFile = sourceFile;
            this.selection = selection;
        }
    }

    private class HighlightRangeJob
    extends Job {
        private final XtextEditor editor;
        private volatile HighlightArgs args;

        public HighlightRangeJob(XtextEditor editor) {
            super("");
            this.setSystem(true);
            this.editor = editor;
        }

        public void setArgs(HighlightArgs args) {
            this.args = args;
        }

        protected IStatus run(IProgressMonitor monitor) {
            int position;
            HighlightArgs args = this.args;
            if (args == null) {
                return Status.OK_STATUS;
            }
            SourceFile sourceFile = args.sourceFile;
            ISelection selection = args.selection;
            ISourceElement selectedElement = null;
            if (selection instanceof ITextSelection && (position = ((ITextSelection)selection).getOffset()) >= 0) {
                try {
                    sourceFile.reconcile(false, monitor);
                }
                catch (CoreException e) {
                    Activator.log(e.getStatus());
                    this.resetEditorHighlightRange(args);
                    return e.getStatus();
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                selectedElement = sourceFile.getElementAt(position, null);
                if (sourceFile.equals((Object)selectedElement)) {
                    selectedElement = null;
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (selectedElement == null || !selectedElement.exists()) {
                this.resetEditorHighlightRange(args);
            } else {
                TextRange r;
                try {
                    r = selectedElement.getSourceElementInfo().getFullRange();
                }
                catch (CoreException e) {
                    Activator.log(e.getStatus());
                    this.resetEditorHighlightRange(args);
                    return e.getStatus();
                }
                if (r != null) {
                    this.setEditorHighlightRange(args, r.getOffset(), r.getLength());
                }
            }
            return Status.OK_STATUS;
        }

        private void setEditorHighlightRange(final HighlightArgs args, final int offset, final int length) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!HighlightRangeJob.this.hasWorldChanged(args)) {
                        HighlightRangeJob.this.editor.setHighlightRange(offset, length, false);
                    }
                }
            });
        }

        private void resetEditorHighlightRange(final HighlightArgs args) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!HighlightRangeJob.this.hasWorldChanged(args)) {
                        HighlightRangeJob.this.editor.resetHighlightRange();
                    }
                }
            });
        }

        private boolean hasWorldChanged(HighlightArgs baseArgs) {
            return baseArgs != this.args || !baseArgs.sourceFile.equals((Object)HandlyXtextEditorCallback.this.getWorkingCopy(this.editor)) || !baseArgs.selection.equals(this.editor.getSelectionProvider().getSelection());
        }
    }
}

