/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.handly.internal.xtext.ui.Activator;
import org.eclipse.handly.xtext.ui.editor.HandlyXtextDocument;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.ContentAssistantFacade;
import org.eclipse.jface.text.source.ISourceViewerExtension4;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.editor.reconciler.XtextReconciler;
import org.eclipse.xtext.util.CancelIndicator;

public class HandlyXtextReconciler
extends XtextReconciler {
    private final InternalReconciler delegate = new InternalReconciler();

    public HandlyXtextReconciler() {
        super(null);
    }

    public void install(ITextViewer textViewer) {
        this.delegate.install(textViewer);
    }

    public void uninstall() {
        this.delegate.uninstall();
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return this.delegate.getReconcilingStrategy(contentType);
    }

    public void setReconcilingStrategy(IReconcilingStrategy strategy) {
    }

    public void setEditor(XtextEditor editor) {
    }

    public void setDelay(int delay) {
        if (this.delegate == null) {
            return;
        }
        this.delegate.setDelay(delay);
    }

    public void forceReconcile() {
        this.delegate.forceReconcile();
    }

    public boolean shouldSchedule() {
        throw new AssertionError();
    }

    private static class InternalReconciler
    extends Job
    implements IReconciler {
        private boolean isInstalled;
        private boolean shouldInstallCompletionListener;
        private volatile boolean paused;
        private final AtomicBoolean forced = new AtomicBoolean();
        private ITextViewer viewer;
        private final TextInputListener textInputListener = new TextInputListener();
        private final DocumentListener documentListener = new DocumentListener();
        private int delay = 500;

        public InternalReconciler() {
            super("Xtext Editor Reconciler");
            this.setPriority(20);
            this.setSystem(true);
        }

        public void setDelay(int delay) {
            this.delay = delay;
        }

        public void forceReconcile() {
            if (this.viewer == null || this.viewer.getDocument() == null) {
                return;
            }
            this.cancel();
            this.forced.set(true);
            this.schedule(this.delay);
        }

        public void install(ITextViewer textViewer) {
            if (!this.isInstalled) {
                this.viewer = textViewer;
                IDocument document0 = this.viewer.getDocument();
                this.viewer.addTextInputListener((ITextInputListener)this.textInputListener);
                IDocument document = this.viewer.getDocument();
                if (document instanceof HandlyXtextDocument && document == document0) {
                    ((HandlyXtextDocument)document).addXtextDocumentContentObserver(this.documentListener);
                }
                if (this.viewer instanceof ISourceViewerExtension4) {
                    ContentAssistantFacade facade = ((ISourceViewerExtension4)this.viewer).getContentAssistantFacade();
                    if (facade == null) {
                        this.shouldInstallCompletionListener = true;
                    } else {
                        facade.addCompletionListener((ICompletionListener)this.documentListener);
                    }
                }
                this.isInstalled = true;
            }
        }

        public void uninstall() {
            if (this.isInstalled) {
                this.viewer.removeTextInputListener((ITextInputListener)this.textInputListener);
                IDocument document = this.viewer.getDocument();
                if (document instanceof HandlyXtextDocument) {
                    ((HandlyXtextDocument)document).removeXtextDocumentContentObserver(this.documentListener);
                }
                if (this.viewer instanceof ISourceViewerExtension4) {
                    ContentAssistantFacade facade = ((ISourceViewerExtension4)this.viewer).getContentAssistantFacade();
                    facade.removeCompletionListener((ICompletionListener)this.documentListener);
                }
                this.isInstalled = false;
            }
        }

        public IReconcilingStrategy getReconcilingStrategy(String contentType) {
            return null;
        }

        public boolean belongsTo(Object family) {
            return XtextReconciler.class.getName().equals(family);
        }

        protected IStatus run(final IProgressMonitor monitor) {
            if (monitor.isCanceled() || this.paused) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = this.viewer.getDocument();
            if (document instanceof HandlyXtextDocument) {
                HandlyXtextDocument doc = (HandlyXtextDocument)document;
                boolean forced = this.forced.compareAndSet(true, false);
                if (forced || doc.needsReconciling()) {
                    try {
                        doc.reconcile(forced, new CancelIndicator(){

                            public boolean isCanceled() {
                                return monitor.isCanceled();
                            }
                        });
                    }
                    catch (OperationCanceledException e) {
                        if (forced) {
                            this.forced.set(true);
                        }
                        throw e;
                    }
                }
            }
            return Status.OK_STATUS;
        }

        private void handleDocumentChanged(DocumentEvent event) {
            this.cancel();
            this.schedule(this.delay);
        }

        private void pause() {
            this.paused = true;
        }

        private void resume() {
            this.paused = false;
            this.schedule(this.delay);
        }

        private class DocumentListener
        implements IXtextDocumentContentObserver,
        ICompletionListener {
            private final IPositionUpdater templatePositionUpdater = new TemplatePositionUpdater("xtext_template_position_category");
            private volatile boolean sessionStarted = false;

            private DocumentListener() {
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                InternalReconciler.this.handleDocumentChanged(event);
            }

            public boolean performNecessaryUpdates(IXtextDocumentContentObserver.Processor processor) {
                boolean hadUpdates = false;
                IDocument document = InternalReconciler.this.viewer.getDocument();
                if (document instanceof HandlyXtextDocument && !InternalReconciler.this.paused) {
                    HandlyXtextDocument doc = (HandlyXtextDocument)document;
                    try {
                        if (doc.needsReconciling()) {
                            hadUpdates = doc.reconcile(processor);
                        }
                    }
                    catch (Throwable e) {
                        Activator.log(Activator.createErrorStatus("Error while forcing reconciliation", e));
                    }
                }
                if (this.sessionStarted && !InternalReconciler.this.paused) {
                    InternalReconciler.this.pause();
                }
                return hadUpdates;
            }

            public boolean hasPendingUpdates() {
                IDocument document = InternalReconciler.this.viewer.getDocument();
                if (document instanceof HandlyXtextDocument) {
                    return ((HandlyXtextDocument)document).needsReconciling();
                }
                return false;
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                IDocument document = InternalReconciler.this.viewer.getDocument();
                document.addPositionCategory("xtext_template_position_category");
                document.addPositionUpdater(this.templatePositionUpdater);
                this.sessionStarted = true;
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                this.sessionStarted = false;
                IDocument document = InternalReconciler.this.viewer.getDocument();
                document.removePositionUpdater(this.templatePositionUpdater);
                try {
                    document.removePositionCategory("xtext_template_position_category");
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                    // empty catch block
                }
                InternalReconciler.this.resume();
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        }

        private static class TemplatePositionUpdater
        extends DefaultPositionUpdater {
            public TemplatePositionUpdater(String category) {
                super(category);
            }

            protected void adaptToInsert() {
                int myStart = this.fPosition.offset;
                int myEnd = this.fPosition.offset + this.fPosition.length - 1;
                myEnd = Math.max(myStart, myEnd);
                int yoursStart = this.fOffset;
                int yoursEnd = this.fOffset + this.fReplaceLength - 1;
                yoursEnd = Math.max(yoursStart, yoursEnd);
                if (myEnd < yoursStart) {
                    return;
                }
                this.fPosition.length += this.fReplaceLength;
            }
        }

        private class TextInputListener
        implements ITextInputListener {
            private TextInputListener() {
            }

            public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
                if (oldInput instanceof HandlyXtextDocument) {
                    ((HandlyXtextDocument)oldInput).removeXtextDocumentContentObserver(InternalReconciler.this.documentListener);
                    InternalReconciler.this.cancel();
                }
            }

            public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                if (newInput instanceof HandlyXtextDocument) {
                    ((HandlyXtextDocument)newInput).addXtextDocumentContentObserver(InternalReconciler.this.documentListener);
                    InternalReconciler.this.schedule(InternalReconciler.this.delay);
                }
                if (InternalReconciler.this.shouldInstallCompletionListener) {
                    ContentAssistantFacade facade = ((ISourceViewerExtension4)InternalReconciler.this.viewer).getContentAssistantFacade();
                    if (facade != null) {
                        facade.addCompletionListener((ICompletionListener)InternalReconciler.this.documentListener);
                    }
                    InternalReconciler.this.shouldInstallCompletionListener = false;
                }
            }
        }
    }
}

