/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.util.LruCache;
import org.eclipse.handly.util.OverflowingLruCache;

public class ElementCache
extends OverflowingLruCache<IHandle, Body> {
    private IHandle spaceLimitParent = null;

    public ElementCache(int size) {
        super(size);
    }

    public ElementCache(int size, int overflow) {
        super(size, overflow);
    }

    public void ensureSpaceLimit(Body body, IHandle parent) {
        int childrenSize = body.getChildren().length;
        int spaceNeeded = 1 + (int)((1.0 + this.loadFactor) * (double)(childrenSize + this.overflow));
        if (this.spaceLimit < spaceNeeded) {
            this.shrink();
            this.setSpaceLimit(spaceNeeded);
            this.spaceLimitParent = parent;
        }
    }

    public void resetSpaceLimit(int defaultLimit, IHandle parent) {
        if (parent.equals(this.spaceLimitParent)) {
            this.setSpaceLimit(defaultLimit);
            this.spaceLimitParent = null;
        }
    }

    @Override
    protected boolean close(LruCache.LruCacheEntry<IHandle, Body> entry) {
        return ((Handle)entry.key).close();
    }

    @Override
    protected OverflowingLruCache<IHandle, Body> newInstance(int size, int newOverflow) {
        return new ElementCache(size, newOverflow);
    }
}

