/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.refactoring;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.refactoring.Messages;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

class UndoSourceFileChange
extends Change {
    private final String name;
    private final ISourceFile sourceFile;
    private final IBufferChange undoChange;
    private boolean existed;

    public UndoSourceFileChange(String name, ISourceFile sourceFile, IBufferChange undoChange) {
        this.name = name;
        if (this.name == null) {
            throw new IllegalArgumentException();
        }
        this.sourceFile = sourceFile;
        if (this.sourceFile == null) {
            throw new IllegalArgumentException();
        }
        this.undoChange = undoChange;
        if (this.undoChange == null) {
            throw new IllegalArgumentException();
        }
    }

    public String getName() {
        return this.name;
    }

    public void initializeValidationData(IProgressMonitor pm) {
        this.existed = this.sourceFile.getFile().exists();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (!this.existed) {
            if (this.sourceFile.getFile().exists()) {
                result.addFatalError(MessageFormat.format(Messages.UndoSourceFileChange_Should_not_exist__0, this.sourceFile.getPath().makeRelative()));
            }
            return result;
        }
        if (!this.sourceFile.getFile().exists()) {
            result.addFatalError(MessageFormat.format(Messages.UndoSourceFileChange_Should_exist__0, this.sourceFile.getPath().makeRelative()));
            return result;
        }
        if (this.undoChange.getBase() == null) {
            return result;
        }
        IBuffer buffer = this.sourceFile.openBuffer(pm);
        try {
            if (!this.undoChange.getBase().isEqualTo(buffer.getSnapshot())) {
                result.addFatalError(MessageFormat.format(Messages.UndoSourceFileChange_Cannot_undo_stale_change__0, this.sourceFile.getPath().makeRelative()));
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            buffer.dispose();
        }
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        try {
            IBuffer buffer = this.sourceFile.openBuffer((IProgressMonitor)new SubProgressMonitor(pm, 1));
            try {
                IBufferChange redoChange;
                try {
                    redoChange = buffer.applyChange(this.undoChange, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
                catch (StaleSnapshotException e) {
                    throw new CoreException(Activator.createErrorStatus(MessageFormat.format(Messages.UndoSourceFileChange_Cannot_undo_stale_change__0, this.sourceFile.getPath().makeRelative()), e));
                }
                UndoSourceFileChange undoSourceFileChange = new UndoSourceFileChange(this.getName(), this.sourceFile, redoChange);
                buffer.dispose();
                return undoSourceFileChange;
            }
            catch (Throwable throwable) {
                buffer.dispose();
                throw throwable;
            }
        }
        finally {
            pm.done();
        }
    }

    public Object getModifiedElement() {
        return this.sourceFile;
    }

    public Object[] getAffectedObjects() {
        return new Object[]{this.sourceFile.getFile()};
    }
}

