/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.BufferChange;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.SaveMode;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooDef;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.examples.basic.ui.model.IFooVar;
import org.eclipse.handly.internal.examples.basic.ui.model.FooFile;
import org.eclipse.handly.junit.WorkspaceTestCase;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.impl.DelegatingWorkingCopyBuffer;
import org.eclipse.handly.model.impl.IWorkingCopyBuffer;
import org.eclipse.handly.model.impl.IWorkingCopyReconciler;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.model.impl.WorkingCopyReconciler;
import org.eclipse.handly.util.TextRange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class FooWorkingCopyTest
extends WorkspaceTestCase {
    private FooFile workingCopy;
    private IWorkingCopyBuffer buffer;

    protected void setUp() throws Exception {
        super.setUp();
        IFooProject fooProject = FooModelCore.create((IProject)this.setUpProject("Test002"));
        this.workingCopy = (FooFile)fooProject.getFooFile("test.foo");
        this.buffer = new DelegatingWorkingCopyBuffer(this.workingCopy.openBuffer(null), (IWorkingCopyReconciler)new WorkingCopyReconciler((SourceFile)this.workingCopy));
    }

    protected void tearDown() throws Exception {
        this.buffer.dispose();
        super.tearDown();
    }

    public void test1() throws Exception {
        this.doWithWorkingCopy(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IFooDef[] defs = FooWorkingCopyTest.this.workingCopy.getDefs();
                FooWorkingCopyTest.assertEquals((int)3, (int)defs.length);
                IFooDef def = FooWorkingCopyTest.this.workingCopy.getDef("f", 0);
                FooWorkingCopyTest.assertEquals((Object)def, (Object)defs[0]);
                TextRange r = defs[0].getSourceElementInfo().getIdentifyingRange();
                BufferChange change = new BufferChange((TextEdit)new ReplaceEdit(r.getOffset(), r.getLength(), "g"));
                change.setSaveMode(SaveMode.LEAVE_UNSAVED);
                FooWorkingCopyTest.this.buffer.applyChange((IBufferChange)change, null);
                defs = FooWorkingCopyTest.this.workingCopy.getDefs();
                FooWorkingCopyTest.assertEquals((int)3, (int)defs.length);
                FooWorkingCopyTest.assertEquals((Object)def, (Object)defs[0]);
                FooWorkingCopyTest.this.workingCopy.reconcile(false, null);
                FooWorkingCopyTest.assertFalse((boolean)def.exists());
                defs = FooWorkingCopyTest.this.workingCopy.getDefs();
                FooWorkingCopyTest.assertEquals((int)3, (int)defs.length);
                FooWorkingCopyTest.assertEquals((Object)FooWorkingCopyTest.this.workingCopy.getDef("g", 0), (Object)defs[0]);
            }
        });
    }

    public void test2() throws Exception {
        this.doWithWorkingCopy(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IFooVar[] vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)2, (int)vars.length);
                IFooVar var1 = FooWorkingCopyTest.this.workingCopy.getVar("x");
                FooWorkingCopyTest.assertEquals((Object)var1, (Object)vars[0]);
                IFooVar var2 = FooWorkingCopyTest.this.workingCopy.getVar("y");
                FooWorkingCopyTest.assertEquals((Object)var2, (Object)vars[1]);
                ISourceElementInfo info = var2.getSourceElementInfo();
                TextRange r = info.getFullRange();
                String var2Text = info.getSnapshot().getContents().substring(r.getOffset(), r.getEndOffset());
                BufferChange change = new BufferChange((TextEdit)new DeleteEdit(r.getOffset(), r.getLength()));
                change.setSaveMode(SaveMode.LEAVE_UNSAVED);
                FooWorkingCopyTest.this.buffer.applyChange((IBufferChange)change, null);
                vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)2, (int)vars.length);
                FooWorkingCopyTest.assertEquals((Object)var2, (Object)vars[1]);
                FooWorkingCopyTest.this.workingCopy.reconcile(false, null);
                FooWorkingCopyTest.assertFalse((boolean)var2.exists());
                vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)1, (int)vars.length);
                FooWorkingCopyTest.assertEquals((Object)var1, (Object)vars[0]);
                info = var1.getSourceElementInfo();
                r = info.getFullRange();
                change = new BufferChange((TextEdit)new InsertEdit(r.getOffset(), var2Text));
                change.setSaveMode(SaveMode.LEAVE_UNSAVED);
                FooWorkingCopyTest.this.buffer.applyChange((IBufferChange)change, null);
                vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)1, (int)vars.length);
                FooWorkingCopyTest.this.workingCopy.reconcile(false, null);
                vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)2, (int)vars.length);
                FooWorkingCopyTest.assertEquals((Object)var2, (Object)vars[0]);
                FooWorkingCopyTest.assertEquals((Object)var1, (Object)vars[1]);
            }
        });
    }

    private void doWithWorkingCopy(IWorkspaceRunnable runnable) throws CoreException {
        this.workingCopy.becomeWorkingCopy(this.buffer, null);
        try {
            runnable.run(null);
        }
        finally {
            this.workingCopy.discardWorkingCopy();
        }
    }
}

