/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.handly.internal.examples.basic.ui.navigator.FooLinkHelper;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.ide.IDE;

class OpenAction
extends BaseSelectionListenerAction {
    private IWorkbenchPage page;

    public OpenAction(IWorkbenchPage page) {
        super("&Open");
        if (page == null) {
            throw new IllegalArgumentException();
        }
        this.page = page;
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null) {
            return;
        }
        for (Object element : selection) {
            IFile file = FooLinkHelper.toFile(element);
            if (file == null) continue;
            IEditorPart editor = null;
            try {
                editor = IDE.openEditor((IWorkbenchPage)this.page, (IFile)file, (boolean)OpenStrategy.activateOnOpen());
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
            if (editor == null) continue;
            FooLinkHelper.revealInEditor(editor, element);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (FooLinkHelper.toFile(element) != null) continue;
            return false;
        }
        return true;
    }
}

