/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.handly.examples.javamodel.ICompilationUnit;
import org.eclipse.handly.examples.javamodel.IJavaElement;
import org.eclipse.handly.examples.javamodel.IJavaProject;
import org.eclipse.handly.examples.javamodel.IPackageFragmentRoot;
import org.eclipse.handly.examples.javamodel.JavaModelCore;
import org.eclipse.handly.internal.examples.javamodel.Activator;
import org.eclipse.handly.internal.examples.javamodel.DeltaProcessingState;
import org.eclipse.handly.internal.examples.javamodel.JavaElementDelta;
import org.eclipse.handly.internal.examples.javamodel.JavaModelBody;
import org.eclipse.handly.internal.examples.javamodel.JavaModelManager;
import org.eclipse.handly.internal.examples.javamodel.JavaProject;
import org.eclipse.handly.internal.examples.javamodel.JavaProjectBody;
import org.eclipse.handly.internal.examples.javamodel.PackageFragmentBody;
import org.eclipse.handly.internal.examples.javamodel.PackageFragmentRootBody;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.model.impl.HandleDelta;
import org.eclipse.jdt.core.IClasspathEntry;

class DeltaProcessor
implements IResourceDeltaVisitor {
    private final JavaElementDelta currentDelta;
    private final DeltaProcessingState state;

    DeltaProcessor(DeltaProcessingState state) {
        this.currentDelta = this.newDelta(state.getJavaModel());
        this.state = state;
    }

    JavaElementDelta getDelta() {
        return this.currentDelta;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        switch (delta.getResource().getType()) {
            case 8: {
                return this.processRoot(delta);
            }
            case 4: {
                return this.processProject(delta);
            }
            case 2: {
                return this.processFolder(delta);
            }
            case 1: {
                return this.processFile(delta);
            }
        }
        return true;
    }

    private boolean processRoot(IResourceDelta delta) throws CoreException {
        this.state.initOldClasspathInfo();
        this.state.initOldJavaProjectNames();
        if ((delta.getFlags() & 0x20000) != 0) {
            this.markersChanged(this.state.getJavaModel(), delta.getMarkerDeltas());
        }
        return true;
    }

    private boolean processProject(IResourceDelta delta) throws CoreException {
        switch (delta.getKind()) {
            case 1: {
                return this.processAddedProject(delta);
            }
            case 2: {
                return this.processRemovedProject(delta);
            }
            case 4: {
                return this.processChangedProject(delta);
            }
        }
        return true;
    }

    private boolean processAddedProject(IResourceDelta delta) throws CoreException {
        IProject project = (IProject)delta.getResource();
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            JavaProject javaProject = (JavaProject)JavaModelCore.create(project);
            this.addToModel(javaProject);
            this.translateAddedDelta(delta, javaProject);
            this.state.classpathChanged(javaProject, false);
        } else {
            this.addResourceDelta(this.state.getJavaModel(), delta);
        }
        return false;
    }

    private boolean processRemovedProject(IResourceDelta delta) throws CoreException {
        IProject project = (IProject)delta.getResource();
        if (this.wasJavaProject(project)) {
            JavaProject javaProject = (JavaProject)JavaModelCore.create(project);
            this.removeFromModel(javaProject);
            this.translateRemovedDelta(delta, javaProject);
            this.state.classpathChanged(javaProject, true);
        } else {
            this.addResourceDelta(this.state.getJavaModel(), delta);
        }
        return false;
    }

    private boolean processChangedProject(IResourceDelta delta) throws CoreException {
        IProject project = (IProject)delta.getResource();
        JavaProject javaProject = (JavaProject)JavaModelCore.create(project);
        if ((delta.getFlags() & 0x4000) != 0) {
            if (project.isOpen()) {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    this.addToModel(javaProject);
                    this.currentDelta.insertChanged(javaProject, 64);
                    this.state.classpathChanged(javaProject, false);
                }
            } else if (this.wasJavaProject(project)) {
                this.removeFromModel(javaProject);
                this.currentDelta.insertChanged(javaProject, 64);
                this.state.classpathChanged(javaProject, true);
            }
            this.addResourceDelta(this.state.getJavaModel(), delta);
            return false;
        }
        boolean isJavaProject = project.hasNature("org.eclipse.jdt.core.javanature");
        if ((delta.getFlags() & 0x80000) != 0) {
            boolean wasJavaProject = this.wasJavaProject(project);
            if (wasJavaProject != isJavaProject) {
                if (isJavaProject) {
                    this.addToModel(javaProject);
                    this.currentDelta.insertAdded(javaProject);
                    this.state.classpathChanged(javaProject, false);
                } else {
                    this.removeFromModel(javaProject);
                    this.currentDelta.insertRemoved(javaProject);
                    this.state.classpathChanged(javaProject, true);
                }
                this.addResourceDelta(this.state.getJavaModel(), delta);
                return false;
            }
            if (isJavaProject) {
                this.currentDelta.insertChanged(javaProject, 128);
            }
        }
        if (isJavaProject) {
            Body parentBody;
            IHandle[] children;
            if ((delta.getFlags() & 0x20000) != 0) {
                this.markersChanged(javaProject, delta.getMarkerDeltas());
            }
            if ((delta.getFlags() & 0x10000) != 0) {
                this.currentDelta.insertChanged(javaProject, 2048);
            }
            if (!Arrays.asList(children = (parentBody = DeltaProcessor.findBody(javaProject.getParent())).getChildren()).contains(javaProject)) {
                this.addToModel(javaProject);
            }
            this.checkClasspathChange(delta);
            return true;
        }
        this.addResourceDelta(this.state.getJavaModel(), delta);
        return false;
    }

    private void checkClasspathChange(IResourceDelta projectDelta) {
        IResourceDelta delta = projectDelta.findMember((IPath)new Path(".classpath"));
        if (delta == null || delta.getResource().getType() != 1) {
            return;
        }
        JavaProject javaProject = (JavaProject)JavaModelCore.create(delta.getResource().getProject());
        switch (delta.getKind()) {
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x100) == 0) break;
            }
            case 1: 
            case 2: {
                if (!this.state.classpathChanged(javaProject, false)) break;
                this.currentDelta.insertChanged(javaProject, 65536);
                DeltaProcessor.close(javaProject);
            }
        }
    }

    private boolean processFolder(IResourceDelta delta) throws CoreException {
        switch (delta.getKind()) {
            case 1: {
                return this.processAddedFolder(delta);
            }
            case 2: {
                return this.processRemovedFolder(delta);
            }
            case 4: {
                return this.processChangedFolder(delta);
            }
        }
        return false;
    }

    private boolean processAddedFolder(IResourceDelta delta) {
        IFolder folder = (IFolder)delta.getResource();
        IJavaElement element = this.state.createElement(folder, false);
        if (element != null) {
            this.addToModel(element);
            this.translateAddedDelta(delta, element);
            return true;
        }
        this.addResourceDelta(this.state.createElement((IResource)delta.getResource().getParent(), false), delta);
        return false;
    }

    private boolean processRemovedFolder(IResourceDelta delta) {
        IFolder folder = (IFolder)delta.getResource();
        IJavaElement element = this.state.createElement(folder, true);
        if (element != null) {
            this.removeFromModel(element);
            this.translateRemovedDelta(delta, element);
            return true;
        }
        this.addResourceDelta(this.state.createElement((IResource)delta.getResource().getParent(), false), delta);
        return false;
    }

    private boolean processChangedFolder(IResourceDelta delta) {
        IFolder folder = (IFolder)delta.getResource();
        IJavaElement element = this.state.createElement(folder, false);
        if (element != null) {
            if ((delta.getFlags() & 0x20000) != 0) {
                this.markersChanged(element, delta.getMarkerDeltas());
            }
            if ((delta.getFlags() & 0x10000) != 0) {
                this.currentDelta.insertChanged(element, 2048);
            }
            return true;
        }
        this.addResourceDelta(this.state.createElement((IResource)delta.getResource().getParent(), false), delta);
        return false;
    }

    private boolean processFile(IResourceDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                return this.processAddedFile(delta);
            }
            case 2: {
                return this.processRemovedFile(delta);
            }
            case 4: {
                return this.processChangedFile(delta);
            }
        }
        return false;
    }

    private boolean processAddedFile(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        IJavaElement element = this.state.createElement(file, false);
        if (element != null) {
            this.addToModel(element);
            this.translateAddedDelta(delta, element);
        } else {
            this.addResourceDelta(this.state.createElement((IResource)delta.getResource().getParent(), false), delta);
        }
        return false;
    }

    private boolean processRemovedFile(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        IJavaElement element = this.state.createElement(file, true);
        if (element != null) {
            this.removeFromModel(element);
            this.translateRemovedDelta(delta, element);
        } else {
            this.addResourceDelta(this.state.createElement((IResource)delta.getResource().getParent(), false), delta);
        }
        return false;
    }

    private boolean processChangedFile(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        IJavaElement element = this.state.createElement(file, false);
        if (element != null) {
            if ((delta.getFlags() & 0xFFFCFFFF) != 0) {
                this.contentChanged(element);
            }
            if ((delta.getFlags() & 0x20000) != 0) {
                this.markersChanged(element, delta.getMarkerDeltas());
            }
            if ((delta.getFlags() & 0x10000) != 0) {
                this.currentDelta.insertChanged(element, 2048);
            }
        } else {
            this.addResourceDelta(this.state.createElement((IResource)delta.getResource().getParent(), false), delta);
        }
        return false;
    }

    private boolean wasJavaProject(IProject project) {
        return this.state.getOldJavaProjectNames().contains(project.getName());
    }

    private void addToModel(IJavaElement element) {
        Body parentBody = DeltaProcessor.findBody(element.getParent());
        if (parentBody != null) {
            if (element instanceof IPackageFragmentRoot) {
                this.addPackageFragmentRoot(parentBody, (IPackageFragmentRoot)element);
            } else {
                parentBody.addChild((IHandle)element);
            }
        }
        DeltaProcessor.close(element);
    }

    private void addPackageFragmentRoot(Body parentBody, IPackageFragmentRoot root) {
        IClasspathEntry[] classpath;
        IHandle[] roots = parentBody.getChildren();
        if (roots.length == 0) {
            parentBody.addChild((IHandle)root);
            return;
        }
        try {
            classpath = ((JavaProject)root.getParent()).getRawClasspath();
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
            parentBody.addChild((IHandle)root);
            return;
        }
        IPath rootPath = root.getPath();
        int indexToInsert = -1;
        int lastComparedIndex = -1;
        int i = 0;
        int j = 0;
        while (i < roots.length && j < classpath.length) {
            IPath entryPath = classpath[j].getPath();
            if (lastComparedIndex != j && rootPath.equals((Object)entryPath)) {
                indexToInsert = i;
                break;
            }
            lastComparedIndex = j++;
            if (!roots[i].getPath().equals((Object)entryPath)) continue;
            ++i;
        }
        while (i < roots.length) {
            if (roots[i].equals((Object)root)) {
                return;
            }
            if (!roots[i].getPath().equals((Object)rootPath)) break;
            ++i;
        }
        if (indexToInsert < 0) {
            parentBody.addChild((IHandle)root);
        } else {
            int newSize = roots.length + 1;
            IHandle[] newChildren = new IHandle[newSize];
            if (indexToInsert > 0) {
                System.arraycopy(roots, 0, newChildren, 0, indexToInsert);
            }
            newChildren[indexToInsert] = root;
            System.arraycopy(roots, indexToInsert, newChildren, indexToInsert + 1, newSize - indexToInsert - 1);
            parentBody.setChildren(newChildren);
        }
    }

    private void removeFromModel(IJavaElement element) {
        Body parentBody = DeltaProcessor.findBody(element.getParent());
        if (parentBody != null) {
            parentBody.removeChild((IHandle)element);
        }
        DeltaProcessor.close(element);
        if (element instanceof IJavaProject) {
            JavaModelManager.INSTANCE.removePerProjectInfo(((IJavaProject)element).getProject());
        }
    }

    private void translateAddedDelta(IResourceDelta delta, IJavaElement element) {
        if ((delta.getFlags() & 0x1000) == 0) {
            this.currentDelta.insertAdded(element);
        } else {
            IJavaElement movedFromElement = this.state.createElement(DeltaProcessor.getResource(delta.getMovedFromPath(), delta.getResource().getType()), true);
            if (movedFromElement == null) {
                this.currentDelta.insertAdded(element);
            } else {
                this.currentDelta.insertMovedTo(element, movedFromElement);
            }
        }
    }

    private void translateRemovedDelta(IResourceDelta delta, IJavaElement element) {
        if ((delta.getFlags() & 0x2000) == 0) {
            this.currentDelta.insertRemoved(element);
        } else {
            IJavaElement movedToElement = this.state.createElement(DeltaProcessor.getResource(delta.getMovedToPath(), delta.getResource().getType()), false);
            if (movedToElement == null) {
                this.currentDelta.insertRemoved(element);
            } else {
                this.currentDelta.insertMovedFrom(element, movedToElement);
            }
        }
    }

    private void contentChanged(IJavaElement element) {
        if (element instanceof ICompilationUnit && ((ICompilationUnit)element).isWorkingCopy()) {
            this.currentDelta.insertChanged(element, 513);
            return;
        }
        DeltaProcessor.close(element);
        this.currentDelta.insertChanged(element, 1);
    }

    private void markersChanged(IJavaElement javaElement, IMarkerDelta[] markerDeltas) {
        HandleDelta delta = this.currentDelta.getDeltaFor(javaElement);
        if (delta == null) {
            delta = this.newDelta(javaElement);
            this.currentDelta.insert(delta);
        }
        delta.setMarkerDeltas(markerDeltas);
    }

    private void addResourceDelta(IJavaElement element, IResourceDelta delta) {
        HandleDelta handleDelta;
        if (element == null) {
            return;
        }
        Body body = DeltaProcessor.findBody(element);
        if (body != null) {
            if (body instanceof JavaModelBody) {
                ((JavaModelBody)body).setNonJavaProjects(null);
            } else if (body instanceof JavaProjectBody) {
                ((JavaProjectBody)body).setNonJavaResources(null);
            } else if (body instanceof PackageFragmentRootBody) {
                ((PackageFragmentRootBody)body).setNonJavaResources(null);
            } else if (body instanceof PackageFragmentBody) {
                ((PackageFragmentBody)body).setNonJavaResources(null);
            } else {
                throw new AssertionError();
            }
        }
        if ((handleDelta = this.currentDelta.getDeltaFor(element)) == null) {
            handleDelta = this.newDelta(element);
            this.currentDelta.insert(handleDelta);
        }
        handleDelta.addResourceDelta(delta);
    }

    private JavaElementDelta newDelta(IJavaElement element) {
        return new JavaElementDelta(element);
    }

    private static Body findBody(IJavaElement element) {
        return ((Handle)element).findBody();
    }

    private static void close(IJavaElement element) {
        ((Handle)element).close();
    }

    private static IResource getResource(IPath fullPath, int resourceType) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        switch (resourceType) {
            case 8: {
                return root;
            }
            case 4: {
                return root.getProject(fullPath.lastSegment());
            }
            case 2: {
                return root.getFolder(fullPath);
            }
            case 1: {
                return root.getFile(fullPath);
            }
        }
        return null;
    }
}

