/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.util.HashMap;
import org.eclipse.handly.examples.javamodel.ICompilationUnit;
import org.eclipse.handly.examples.javamodel.IJavaModel;
import org.eclipse.handly.examples.javamodel.IJavaProject;
import org.eclipse.handly.examples.javamodel.IPackageFragment;
import org.eclipse.handly.examples.javamodel.IPackageFragmentRoot;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.ElementCache;
import org.eclipse.handly.model.impl.IBodyCache;

class JavaModelCache
implements IBodyCache {
    private static final int DEFAULT_PROJECT_SIZE = 5;
    private static final int DEFAULT_ROOT_SIZE = 50;
    private static final int DEFAULT_PKG_SIZE = 500;
    private static final int DEFAULT_FILE_SIZE = 250;
    private static final int DEFAULT_CHILDREN_SIZE = 5000;
    private final double memoryRatio = this.getMemoryRatio();
    private Body modelBody;
    private HashMap<IHandle, Body> projectCache = new HashMap(5);
    private ElementCache rootCache = new ElementCache((int)(50.0 * this.memoryRatio));
    private ElementCache pkgCache = new ElementCache((int)(500.0 * this.memoryRatio));
    private ElementCache fileCache = new ElementCache((int)(250.0 * this.memoryRatio));
    private HashMap<IHandle, Body> childrenCache = new HashMap((int)(5000.0 * this.memoryRatio));

    public Body get(IHandle handle) {
        if (handle instanceof IJavaModel) {
            return this.modelBody;
        }
        if (handle instanceof IJavaProject) {
            return this.projectCache.get(handle);
        }
        if (handle instanceof IPackageFragmentRoot) {
            return (Body)this.rootCache.get((Object)handle);
        }
        if (handle instanceof IPackageFragment) {
            return (Body)this.pkgCache.get((Object)handle);
        }
        if (handle instanceof ICompilationUnit) {
            return (Body)this.fileCache.get((Object)handle);
        }
        return this.childrenCache.get(handle);
    }

    public Body peek(IHandle handle) {
        if (handle instanceof IJavaModel) {
            return this.modelBody;
        }
        if (handle instanceof IJavaProject) {
            return this.projectCache.get(handle);
        }
        if (handle instanceof IPackageFragmentRoot) {
            return (Body)this.rootCache.peek((Object)handle);
        }
        if (handle instanceof IPackageFragment) {
            return (Body)this.pkgCache.peek((Object)handle);
        }
        if (handle instanceof ICompilationUnit) {
            return (Body)this.fileCache.peek((Object)handle);
        }
        return this.childrenCache.get(handle);
    }

    public void put(IHandle handle, Body body) {
        if (handle instanceof IJavaModel) {
            this.modelBody = body;
        } else if (handle instanceof IJavaProject) {
            this.projectCache.put(handle, body);
            this.rootCache.ensureSpaceLimit(body, handle);
        } else if (handle instanceof IPackageFragmentRoot) {
            this.rootCache.put((Object)handle, (Object)body);
            this.pkgCache.ensureSpaceLimit(body, handle);
        } else if (handle instanceof IPackageFragment) {
            this.pkgCache.put((Object)handle, (Object)body);
            this.fileCache.ensureSpaceLimit(body, handle);
        } else if (handle instanceof ICompilationUnit) {
            this.fileCache.put((Object)handle, (Object)body);
        } else {
            this.childrenCache.put(handle, body);
        }
    }

    public void remove(IHandle handle) {
        if (handle instanceof IJavaModel) {
            this.modelBody = null;
        } else if (handle instanceof IJavaProject) {
            this.projectCache.remove(handle);
            this.rootCache.resetSpaceLimit((int)(50.0 * this.memoryRatio), handle);
        } else if (handle instanceof IPackageFragmentRoot) {
            this.rootCache.remove((Object)handle);
            this.pkgCache.resetSpaceLimit((int)(500.0 * this.memoryRatio), handle);
        } else if (handle instanceof IPackageFragment) {
            this.pkgCache.remove((Object)handle);
            this.fileCache.resetSpaceLimit((int)(250.0 * this.memoryRatio), handle);
        } else if (handle instanceof ICompilationUnit) {
            this.fileCache.remove((Object)handle);
        } else {
            this.childrenCache.remove(handle);
        }
    }

    private double getMemoryRatio() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        return maxMemory == Long.MAX_VALUE ? 4.0 : (double)maxMemory / 6.7108864E7;
    }
}

