/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.examples.javamodel.IMethod;
import org.eclipse.handly.internal.examples.javamodel.Member;
import org.eclipse.handly.internal.examples.javamodel.Type;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.model.impl.SourceElementBody;
import org.eclipse.jdt.core.Signature;

public class Method
extends Member
implements IMethod {
    private final String[] parameterTypes;

    public Method(Type parent, String name, String[] parameterTypes) {
        super((Handle)parent, name);
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException();
        }
        this.parameterTypes = parameterTypes;
    }

    @Override
    public Type getParent() {
        return (Type)this.parent;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Method)) {
            return false;
        }
        return super.equals(obj) && Arrays.equals(this.parameterTypes, ((Method)obj).parameterTypes);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        String[] stringArray = this.parameterTypes;
        int n = this.parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterType = stringArray[n2];
            result = 31 * result + parameterType.hashCode();
            ++n2;
        }
        return result;
    }

    @Override
    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public String[] getParameterNames() throws CoreException {
        String[] result = (String[])this.getSourceElementInfo().get(PARAMETER_NAMES);
        if (result == null) {
            return NO_STRINGS;
        }
        return result;
    }

    @Override
    public String getReturnType() throws CoreException {
        String result = (String)this.getSourceElementInfo().get(RETURN_TYPE);
        if (result == null) {
            return "V";
        }
        return result;
    }

    @Override
    public String[] getExceptionTypes() throws CoreException {
        String[] result = (String[])this.getSourceElementInfo().get(EXCEPTION_TYPES);
        if (result == null) {
            return NO_STRINGS;
        }
        return result;
    }

    @Override
    public String getSignature() throws CoreException {
        return Signature.createMethodSignature((String[])this.parameterTypes, (String)this.getReturnType());
    }

    @Override
    public boolean isConstructor() throws CoreException {
        Boolean result = (Boolean)this.getSourceElementInfo().get(IS_CONSTRUCTOR);
        if (result == null) {
            return false;
        }
        return result;
    }

    protected void toStringName(StringBuilder builder) {
        builder.append(this.getName());
        builder.append('(');
        String[] parameterTypes = this.getParameterTypes();
        int length = parameterTypes.length;
        int i = 0;
        while (i < length) {
            String parameterType;
            try {
                parameterType = Signature.toString((String)parameterTypes[i]);
            }
            catch (IllegalArgumentException e) {
                parameterType = "*** invalid signature: " + parameterTypes[i];
            }
            builder.append(parameterType);
            if (i < length - 1) {
                builder.append(", ");
            }
            ++i;
        }
        builder.append(')');
        int occurenceCount = this.getOccurenceCount();
        if (occurenceCount > 1) {
            builder.append('#');
            builder.append(occurenceCount);
        }
    }

    protected void toStringBody(int tab, StringBuilder builder, Body body, boolean showResolvedInfo) {
        SourceElementBody methodBody;
        String returnType;
        builder.append(this.tabString(tab));
        if (body != null && body != NO_BODY && (returnType = (String)(methodBody = (SourceElementBody)body).get(RETURN_TYPE)) != null) {
            builder.append(Signature.toString((String)returnType));
            builder.append(' ');
        }
        this.toStringName(builder);
        if (body == null) {
            builder.append(" (not open)");
        }
    }
}

