/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.handly.examples.javamodel.ICompilationUnit;
import org.eclipse.handly.examples.javamodel.IJavaModel;
import org.eclipse.handly.examples.javamodel.IPackageFragment;
import org.eclipse.handly.internal.examples.javamodel.Activator;
import org.eclipse.handly.internal.examples.javamodel.CompilationUnit;
import org.eclipse.handly.internal.examples.javamodel.JavaModelManager;
import org.eclipse.handly.internal.examples.javamodel.JavaProject;
import org.eclipse.handly.internal.examples.javamodel.PackageFragmentBody;
import org.eclipse.handly.internal.examples.javamodel.PackageFragmentRoot;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.model.impl.HandleManager;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.Signature;

public class PackageFragment
extends Handle
implements IPackageFragment {
    private final String[] simpleNames;

    public PackageFragment(PackageFragmentRoot parent, String name) {
        super((Handle)parent, name);
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.simpleNames = Signature.getSimpleNames((String)name);
    }

    PackageFragment(PackageFragmentRoot parent, String[] simpleNames) {
        super((Handle)parent, Signature.toQualifiedName((String[])simpleNames));
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.simpleNames = simpleNames;
    }

    @Override
    public PackageFragmentRoot getParent() {
        return (PackageFragmentRoot)this.parent;
    }

    @Override
    public IJavaModel getRoot() {
        return (IJavaModel)super.getRoot();
    }

    public IResource getResource() {
        if (this.simpleNames.length == 0) {
            return this.parent.getResource();
        }
        Path path = Path.EMPTY;
        String[] stringArray = this.simpleNames;
        int n = this.simpleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String simpleName = stringArray[n2];
            path = path.append(simpleName);
            ++n2;
        }
        return ((IContainer)this.parent.getResource()).getFolder((IPath)path);
    }

    @Override
    public ICompilationUnit getCompilationUnit(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return new CompilationUnit(this, ((IContainer)this.getResource()).getFile((IPath)new Path(name)));
    }

    @Override
    public ICompilationUnit[] getCompilationUnits() throws CoreException {
        IHandle[] children = this.getChildren();
        int length = children.length;
        ICompilationUnit[] result = new ICompilationUnit[length];
        System.arraycopy(children, 0, result, 0, length);
        return result;
    }

    @Override
    public Object[] getNonJavaResources() throws CoreException {
        if (this.isDefaultPackage()) {
            return PackageFragmentBody.NO_NON_JAVA_RESOURCES;
        }
        return ((PackageFragmentBody)this.getBody()).getNonJavaResources(this);
    }

    @Override
    public boolean isDefaultPackage() {
        return this.name.isEmpty();
    }

    protected HandleManager getHandleManager() {
        return JavaModelManager.INSTANCE.getHandleManager();
    }

    protected void validateExistence() throws CoreException {
        if (!this.isValidPackageName()) {
            throw new CoreException(Activator.createErrorStatus(MessageFormat.format("Invalid Java package name: {0}", this.name), null));
        }
        IResource resource = this.getResource();
        if (resource != null && !resource.isAccessible()) {
            throw new CoreException(Activator.createErrorStatus(MessageFormat.format("Resource ''{0}'' is not accessible", resource.getFullPath()), null));
        }
    }

    boolean isValidPackageName() {
        JavaProject javaProject = this.getParent().getParent();
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        String[] stringArray = this.simpleNames;
        int n = this.simpleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String simpleName = stringArray[n2];
            if (JavaConventions.validateIdentifier((String)simpleName, (String)sourceLevel, (String)complianceLevel).getSeverity() == 4) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected Body newBody() {
        return new PackageFragmentBody();
    }

    protected void buildStructure(Body body, Map<IHandle, Body> newElements) throws CoreException {
        HashSet<CompilationUnit> children = new HashSet<CompilationUnit>();
        IResource[] members = ((IContainer)this.getResource()).members();
        if (members.length > 0) {
            JavaProject javaProject = (JavaProject)this.getAncestor(JavaProject.class);
            String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
            String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member instanceof IFile && JavaConventions.validateCompilationUnitName((String)member.getName(), (String)sourceLevel, (String)complianceLevel).getSeverity() != 4) {
                    children.add(new CompilationUnit(this, (IFile)member));
                }
                ++n2;
            }
        }
        body.setChildren(children.toArray(new IHandle[children.size()]));
    }

    protected void toStringName(StringBuilder builder) {
        if (this.isDefaultPackage()) {
            builder.append("<default>");
        } else {
            super.toStringName(builder);
        }
    }

    protected void toStringBody(int tab, StringBuilder builder, Body body, boolean showResolvedInfo) {
        super.toStringBody(tab, builder, body, showResolvedInfo);
        if (body != null && tab > 0) {
            builder.append(" (...)");
        }
    }

    protected void toStringChildren(int tab, StringBuilder builder, Body body) {
        if (tab == 0) {
            super.toStringChildren(tab, builder, body);
        }
    }
}

