/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.handly.ui.outline.ICommonOutlinePage;
import org.eclipse.handly.ui.outline.IOutlineContribution;
import org.eclipse.handly.ui.outline.IOutlineInputChangeListener;
import org.eclipse.handly.ui.preference.IBooleanPreference;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public abstract class CommonOutlinePage
extends Page
implements ICommonOutlinePage {
    private TreeViewer treeViewer;
    private IEditorPart editor;
    private ListenerList contributionList = new ListenerList();
    private ListenerList inputChangeListeners = new ListenerList();
    private ListenerList selectionChangedListeners = new ListenerList();
    private IPropertyListener editorInputListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 258) {
                CommonOutlinePage.this.editorInputChanged();
            }
        }
    };

    @Override
    public final TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    @Override
    public void init(IEditorPart editor) {
        if (editor == null) {
            throw new IllegalArgumentException();
        }
        this.editor = editor;
    }

    @Override
    public final IEditorPart getEditor() {
        return this.editor;
    }

    @Override
    public void addOutlineContribution(IOutlineContribution contribution) {
        this.contributionList.add((Object)contribution);
        if (this.getTreeViewer() != null) {
            contribution.init(this);
        }
    }

    @Override
    public void removeOutlineContribution(IOutlineContribution contribution) {
        this.contributionList.remove((Object)contribution);
        if (this.getTreeViewer() != null) {
            contribution.dispose();
        }
    }

    @Override
    public void addInputChangeListener(IOutlineInputChangeListener listener) {
        this.inputChangeListeners.add((Object)listener);
    }

    @Override
    public void removeInputChangeListener(IOutlineInputChangeListener listener) {
        this.inputChangeListeners.remove((Object)listener);
    }

    @Override
    public IBooleanPreference getLinkWithEditorPreference() {
        return null;
    }

    @Override
    public IBooleanPreference getLexicalSortPreference() {
        return null;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public final Control getControl() {
        if (this.treeViewer == null) {
            return null;
        }
        return this.treeViewer.getControl();
    }

    public void createControl(Composite parent) {
        if (this.editor == null) {
            throw new IllegalStateException("init(IEditorPart) must be called before the outline page's control is created");
        }
        this.treeViewer = this.createTreeViewer(parent);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CommonOutlinePage.this.fireSelectionChanged(event.getSelection());
            }
        });
        this.treeViewer.setUseHashlookup(this.shouldUseHashlookup());
        this.treeViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.treeViewer.setLabelProvider(this.getLabelProvider());
        this.treeViewer.setInput(this.computeInput());
        this.editor.addPropertyListener(this.editorInputListener);
        this.registerGlobalActions();
        this.initContributions();
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.removePropertyListener(this.editorInputListener);
        }
        this.disposeContributions();
        super.dispose();
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        if (this.treeViewer != null) {
            this.treeViewer.setSelection(selection);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void refresh() {
        Control control = this.treeViewer.getControl();
        control.setRedraw(false);
        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                TreePath[] treePaths = CommonOutlinePage.this.treeViewer.getExpandedTreePaths();
                CommonOutlinePage.this.treeViewer.refresh();
                CommonOutlinePage.this.treeViewer.setExpandedTreePaths(treePaths);
            }
        });
        control.setRedraw(true);
    }

    protected boolean shouldUseHashlookup() {
        return true;
    }

    protected abstract ITreeContentProvider getContentProvider();

    protected abstract IBaseLabelProvider getLabelProvider();

    protected abstract Object computeInput();

    protected OutlineTreeViewer createTreeViewer(Composite parent) {
        return new OutlineTreeViewer(new Tree(parent, 770));
    }

    protected void editorInputChanged() {
        this.treeViewer.setInput(this.computeInput());
    }

    protected boolean isAutoExpandable(TreeItem item) {
        return item.getParentItem() == null;
    }

    protected void registerGlobalActions() {
        IActionBars actionBars = this.getSite().getActionBars();
        if (this.editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)this.editor;
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, textEditor.getAction(ITextEditorActionConstants.UNDO));
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, textEditor.getAction(ITextEditorActionConstants.REDO));
            IAction action = textEditor.getAction(ITextEditorActionConstants.NEXT);
            actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", action);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.NEXT, action);
            action = textEditor.getAction(ITextEditorActionConstants.PREVIOUS);
            actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", action);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.PREVIOUS, action);
        }
    }

    private void initContributions() {
        Object[] contributions;
        Object[] objectArray = contributions = this.contributionList.getListeners();
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            final Object contribution = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IOutlineContribution)contribution).init(CommonOutlinePage.this);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++n2;
        }
    }

    private void disposeContributions() {
        Object[] contributions;
        Object[] objectArray = contributions = this.contributionList.getListeners();
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            final Object contribution = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IOutlineContribution)contribution).dispose();
                }

                public void handleException(Throwable exception) {
                }
            });
            ++n2;
        }
    }

    private void fireInputChanged(final Object input, final Object oldInput) {
        Object[] listeners;
        Object[] objectArray = listeners = this.inputChangeListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() {
                    ((IOutlineInputChangeListener)listener).inputChanged(CommonOutlinePage.this, input, oldInput);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++n2;
        }
    }

    private void fireSelectionChanged(ISelection selection) {
        Object[] listeners;
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] objectArray = listeners = this.selectionChangedListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() {
                    ((ISelectionChangedListener)listener).selectionChanged(event);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++n2;
        }
    }

    protected class OutlineTreeViewer
    extends TreeViewer {
        public OutlineTreeViewer(Tree tree) {
            super(tree);
            this.setAutoExpandLevel(-1);
        }

        protected void inputChanged(Object input, Object oldInput) {
            super.inputChanged(input, oldInput);
            CommonOutlinePage.this.fireInputChanged(input, oldInput);
        }

        protected void internalExpandToLevel(Widget node, int level) {
            TreeItem item;
            if (node instanceof TreeItem && !this.canExpand(item = (TreeItem)node)) {
                this.setExpanded((Item)item, false);
                return;
            }
            super.internalExpandToLevel(node, level);
        }

        protected boolean canExpand(TreeItem item) {
            return CommonOutlinePage.this.isAutoExpandable(item);
        }
    }
}

