/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import org.eclipse.handly.ui.outline.ICommonOutlinePage;
import org.eclipse.handly.ui.outline.OutlineContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;

public class OutlineContextMenuContribution
extends OutlineContribution {
    private Menu menu;
    private Menu oldMenu;

    @Override
    public void init(ICommonOutlinePage outlinePage) {
        super.init(outlinePage);
        MenuManager manager = new MenuManager(this.getContextMenuId(), this.getContextMenuId());
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                OutlineContextMenuContribution.this.contextMenuAboutToShow(manager);
            }
        });
        Tree tree = outlinePage.getTreeViewer().getTree();
        this.menu = manager.createContextMenu((Control)tree);
        this.oldMenu = tree.getMenu();
        tree.setMenu(this.menu);
        String menuId = this.getContextMenuExtensionId();
        if (menuId != null) {
            outlinePage.getSite().registerContextMenu(menuId, manager, (ISelectionProvider)outlinePage.getTreeViewer());
        }
    }

    @Override
    public void dispose() {
        if (this.menu != null) {
            this.getOutlinePage().getTreeViewer().getTree().setMenu(this.oldMenu);
            this.menu.dispose();
            this.menu = null;
            this.oldMenu = null;
        }
        super.dispose();
    }

    protected String getContextMenuId() {
        return null;
    }

    protected String getContextMenuExtensionId() {
        return null;
    }

    protected void contextMenuAboutToShow(IMenuManager manager) {
        if (this.getContextMenuExtensionId() != null) {
            manager.add((IContributionItem)new Separator("additions"));
        }
    }
}

