/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import org.eclipse.handly.ui.outline.ICommonOutlinePage;
import org.eclipse.handly.ui.outline.OutlineContribution;
import org.eclipse.handly.ui.preference.IBooleanPreference;
import org.eclipse.handly.ui.preference.IPreferenceListener;
import org.eclipse.handly.ui.preference.PreferenceChangeEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class OutlineFilterContribution
extends OutlineContribution {
    private ViewerFilter filter;
    private IBooleanPreference preference;
    private IPreferenceListener preferenceListener = new IPreferenceListener(){

        @Override
        public void preferenceChanged(PreferenceChangeEvent event) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (OutlineFilterContribution.this.preference == null) {
                        return;
                    }
                    final TreeViewer treeViewer = OutlineFilterContribution.this.getOutlinePage().getTreeViewer();
                    Control control = treeViewer.getControl();
                    control.setRedraw(false);
                    BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TreePath[] treePaths = treeViewer.getExpandedTreePaths();
                            if (OutlineFilterContribution.this.preference.getValue()) {
                                treeViewer.addFilter(OutlineFilterContribution.this.filter);
                            } else {
                                treeViewer.removeFilter(OutlineFilterContribution.this.filter);
                            }
                            treeViewer.setExpandedTreePaths(treePaths);
                        }
                    });
                    control.setRedraw(true);
                }
            });
        }
    };

    @Override
    public void init(ICommonOutlinePage outlinePage) {
        super.init(outlinePage);
        this.preference = this.getPreference();
        if (this.preference != null) {
            this.filter = this.getFilter();
            if (this.preference.getValue()) {
                outlinePage.getTreeViewer().addFilter(this.filter);
            }
            this.preference.addListener(this.preferenceListener);
        }
    }

    @Override
    public void dispose() {
        if (this.preference != null) {
            this.preference.removeListener(this.preferenceListener);
            this.getOutlinePage().getTreeViewer().removeFilter(this.filter);
            this.preference = null;
        }
        super.dispose();
    }

    protected abstract IBooleanPreference getPreference();

    protected abstract ViewerFilter getFilter();
}

