/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.texteditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.model.IHandle;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.DelegatingWorkingCopyBuffer;
import org.eclipse.handly.model.impl.IWorkingCopyBuffer;
import org.eclipse.handly.model.impl.IWorkingCopyReconciler;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.model.impl.WorkingCopyReconciler;
import org.eclipse.handly.ui.IElementForEditorInputFactory;
import org.eclipse.handly.ui.IWorkingCopyManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SourceFileDocumentProvider
extends TextFileDocumentProvider
implements IWorkingCopyManager {
    protected final IElementForEditorInputFactory inputElementFactory;

    public SourceFileDocumentProvider(IElementForEditorInputFactory factory) {
        this(factory, null);
    }

    public SourceFileDocumentProvider(IElementForEditorInputFactory factory, IDocumentProvider parentProvider) {
        super(parentProvider);
        this.inputElementFactory = factory;
    }

    @Override
    public ISourceFile getWorkingCopy(IEditorInput input) {
        TextFileDocumentProvider.FileInfo info = this.getFileInfo(input);
        if (info instanceof WorkingCopyInfo) {
            return ((WorkingCopyInfo)info).workingCopy;
        }
        return null;
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new WorkingCopyInfo();
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (!(info instanceof WorkingCopyInfo)) {
            return null;
        }
        SourceFile sourceFile = this.getSourceFile(element);
        if (sourceFile == null) {
            return null;
        }
        DelegatingWorkingCopyBuffer buffer = new DelegatingWorkingCopyBuffer(sourceFile.openBuffer(null), this.createWorkingCopyReconciler(sourceFile, element));
        try {
            sourceFile.becomeWorkingCopy((IWorkingCopyBuffer)buffer, null);
        }
        finally {
            buffer.dispose();
        }
        ((WorkingCopyInfo)info).workingCopy = sourceFile;
        return info;
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        if (info instanceof WorkingCopyInfo) {
            ((WorkingCopyInfo)info).workingCopy.discardWorkingCopy();
        }
        super.disposeFileInfo(element, info);
    }

    protected SourceFile getSourceFile(Object element) {
        if (!(element instanceof IEditorInput)) {
            return null;
        }
        IHandle inputElement = this.inputElementFactory.getElement((IEditorInput)element);
        if (!(inputElement instanceof SourceFile)) {
            return null;
        }
        return (SourceFile)inputElement;
    }

    protected IWorkingCopyReconciler createWorkingCopyReconciler(SourceFile sourceFile, Object element) {
        return new WorkingCopyReconciler(sourceFile);
    }

    protected static class WorkingCopyInfo
    extends TextFileDocumentProvider.FileInfo {
        public SourceFile workingCopy;

        protected WorkingCopyInfo() {
        }
    }
}

