/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.workingset;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.handly.model.IHandle;
import org.eclipse.ui.IContainmentAdapter;

public abstract class AbstractContainmentAdapter
implements IContainmentAdapter {
    public boolean contains(Object workingSetElement, Object element, int flags) {
        if (!(workingSetElement instanceof IHandle) || element == null) {
            return false;
        }
        IHandle castedWorkingSetElement = (IHandle)workingSetElement;
        IHandle castedElement = null;
        IResource resource = null;
        if (element instanceof IHandle) {
            castedElement = (IHandle)element;
        } else {
            if (element instanceof IResource) {
                resource = (IResource)element;
            } else if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                resource = (IResource)adaptable.getAdapter(IResource.class);
            }
            if (resource != null) {
                castedElement = this.getElementFor(resource);
            }
        }
        if (castedElement != null) {
            return this.contains(castedWorkingSetElement, castedElement, flags);
        }
        if (resource != null) {
            return this.contains(castedWorkingSetElement, resource, flags);
        }
        return false;
    }

    protected abstract IHandle getElementFor(IResource var1);

    protected boolean contains(IHandle workingSetElement, IHandle element, int flags) {
        if (AbstractContainmentAdapter.checkContext(flags) && workingSetElement.equals((Object)element)) {
            return true;
        }
        if (AbstractContainmentAdapter.checkIfChild(flags) && workingSetElement.equals((Object)element.getParent())) {
            return true;
        }
        if (AbstractContainmentAdapter.checkIfDescendant(flags) && this.check(workingSetElement, element)) {
            return true;
        }
        return AbstractContainmentAdapter.checkIfAncestor(flags) && this.check(element, workingSetElement);
    }

    protected boolean check(IHandle ancestor, IHandle descendent) {
        descendent = descendent.getParent();
        while (descendent != null) {
            if (ancestor.equals((Object)descendent)) {
                return true;
            }
            descendent = descendent.getParent();
        }
        return false;
    }

    protected boolean contains(IHandle workingSetElement, IResource resource, int flags) {
        IResource workingSetResource = workingSetElement.getResource();
        if (workingSetResource == null) {
            return false;
        }
        if (AbstractContainmentAdapter.checkContext(flags) && workingSetResource.equals((Object)resource)) {
            return true;
        }
        if (AbstractContainmentAdapter.checkIfChild(flags) && workingSetResource.equals((Object)resource.getParent())) {
            return true;
        }
        if (AbstractContainmentAdapter.checkIfDescendant(flags) && this.check(workingSetResource, resource)) {
            return true;
        }
        return AbstractContainmentAdapter.checkIfAncestor(flags) && this.check(resource, workingSetResource);
    }

    protected boolean check(IResource ancestor, IResource descendent) {
        descendent = descendent.getParent();
        while (descendent != null) {
            if (ancestor.equals((Object)descendent)) {
                return true;
            }
            descendent = descendent.getParent();
        }
        return false;
    }

    protected static boolean checkContext(int flags) {
        return (flags & 1) != 0;
    }

    protected static boolean checkIfChild(int flags) {
        return (flags & 2) != 0;
    }

    protected static boolean checkIfAncestor(int flags) {
        return (flags & 4) != 0;
    }

    protected static boolean checkIfDescendant(int flags) {
        return (flags & 8) != 0;
    }
}

