/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.handly.buffer.BufferChangeOperation;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.jface.text.BadLocationException;

public final class UiBufferChangeRunner {
    private final UiSynchronizer synchronizer;
    private final BufferChangeOperation operation;

    public UiBufferChangeRunner(UiSynchronizer synchronizer, BufferChangeOperation operation) {
        this.synchronizer = synchronizer;
        if (this.synchronizer == null) {
            throw new IllegalArgumentException();
        }
        this.operation = operation;
        if (this.operation == null) {
            throw new IllegalArgumentException();
        }
    }

    public IBufferChange run(final IProgressMonitor monitor) throws CoreException, BadLocationException {
        Thread synchronizerThread;
        final Thread callerThread = Thread.currentThread();
        if (callerThread.equals(synchronizerThread = this.synchronizer.getThread())) {
            return this.operation.execute(monitor);
        }
        final IBufferChange[] undoChange = new IBufferChange[1];
        final Throwable[] exception = new Throwable[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        undoChange[0] = UiBufferChangeRunner.this.operation.execute(monitor);
                    }
                    finally {
                        UiBufferChangeRunner.this.transferCurrentRule(callerThread);
                    }
                }
                catch (Throwable e) {
                    exception[0] = e;
                }
            }
        };
        this.transferCurrentRule(synchronizerThread);
        this.synchronizer.syncExec(runnable);
        if (exception[0] != null) {
            Throwable e = exception[0];
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof CoreException) {
                throw (CoreException)e;
            }
            if (e instanceof BadLocationException) {
                throw (BadLocationException)e;
            }
            throw new AssertionError((Object)e);
        }
        return undoChange[0];
    }

    private void transferCurrentRule(Thread destinationThread) {
        IJobManager jobManager = Job.getJobManager();
        jobManager.transferRule(jobManager.currentRule(), destinationThread);
    }
}

