/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.impl.Handle;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.util.TextRange;

public abstract class SourceElement
extends Handle
implements ISourceElement {
    public SourceElement(Handle parent, String name) {
        super(parent, name);
    }

    @Override
    public final ISourceElement getElementAt(int position, ISnapshot base) {
        try {
            return this.doGetElementAt(position, base);
        }
        catch (CoreException coreException) {
        }
        catch (StaleSnapshotException staleSnapshotException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public ISourceElementInfo getSourceElementInfo() throws CoreException {
        return (ISourceElementInfo)((Object)this.getBody());
    }

    public ISourceElement doGetElementAt(int position, ISnapshot base) throws CoreException {
        ISourceElementInfo info = this.getSourceElementInfo();
        if (!SourceElement.checkInRange(position, base, info)) {
            return null;
        }
        return this.getElementAt(position, info);
    }

    protected static boolean checkInRange(int position, ISnapshot base, ISourceElementInfo info) {
        ISnapshot snapshot = info.getSnapshot();
        if (snapshot == null) {
            return false;
        }
        if (base != null && !base.isEqualTo(snapshot)) {
            throw new StaleSnapshotException();
        }
        TextRange textRange = info.getFullRange();
        return textRange != null && textRange.covers(position);
    }

    protected ISourceElement getElementAt(int position, ISourceElementInfo info) throws CoreException {
        ISourceConstruct[] children;
        ISnapshot snapshot = info.getSnapshot();
        ISourceConstruct[] iSourceConstructArray = children = info.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceConstruct child = iSourceConstructArray[n2];
            ISourceElement found = ((SourceElement)((Object)child)).doGetElementAt(position, snapshot);
            if (found != null) {
                return found;
            }
            ++n2;
        }
        return this;
    }
}

