/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.adapter;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.handly.internal.examples.adapter.JavaElementDelta;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.impl.ElementChangeEvent;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;

public class AdapterModelManager
implements IElementChangedListener {
    public static final AdapterModelManager INSTANCE = new AdapterModelManager();
    private ListenerList listenerList;

    public void startup() throws Exception {
        try {
            this.listenerList = new ListenerList();
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        }
        catch (Exception e) {
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() throws Exception {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        this.listenerList = null;
    }

    public void addElementChangeListener(IElementChangeListener listener) {
        if (this.listenerList == null) {
            throw new IllegalStateException();
        }
        this.listenerList.add((Object)listener);
    }

    public void removeElementChangeListener(IElementChangeListener listener) {
        if (this.listenerList == null) {
            throw new IllegalStateException();
        }
        this.listenerList.remove((Object)listener);
    }

    public void fireElementChangeEvent(final IElementChangeEvent event) {
        Object[] listeners;
        if (this.listenerList == null) {
            throw new IllegalStateException();
        }
        Object[] objectArray = listeners = this.listenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    ((IElementChangeListener)listener).elementChanged(event);
                }
            });
            ++n2;
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        this.fireElementChangeEvent(AdapterModelManager.convert(event));
    }

    private static IElementChangeEvent convert(ElementChangedEvent event) {
        int type = event.getType();
        int convertedType = 0;
        if ((type & 1) != 0) {
            convertedType |= 1;
        }
        if ((type & 4) != 0) {
            convertedType |= 2;
        }
        JavaElementDelta convertedDelta = new JavaElementDelta(event.getDelta());
        return new ElementChangeEvent(convertedType, (IElementDelta)convertedDelta);
    }

    private AdapterModelManager() {
    }
}

