/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.adapter;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.handly.internal.examples.adapter.JavaSourceConstruct;
import org.eclipse.handly.internal.examples.adapter.JavaSourceElement;
import org.eclipse.handly.internal.examples.adapter.JavaSourceFile;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ToStringStyle;
import org.eclipse.handly.model.impl.IElementImpl;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceReference;

public class JavaElement
extends PlatformObject
implements IElementImpl {
    private static final IElement[] NO_CHILDREN = new IElement[0];
    private final IJavaElement javaElement;

    public static IElement create(IJavaElement javaElement) {
        if (javaElement == null) {
            return null;
        }
        if (javaElement instanceof ICompilationUnit) {
            return new JavaSourceFile((ICompilationUnit)javaElement);
        }
        if (javaElement instanceof IClassFile) {
            return new JavaSourceElement(javaElement);
        }
        if (javaElement instanceof ISourceReference) {
            return new JavaSourceConstruct(javaElement);
        }
        return new JavaElement(javaElement);
    }

    JavaElement(IJavaElement javaElement) {
        if (javaElement == null) {
            throw new IllegalArgumentException();
        }
        this.javaElement = javaElement;
    }

    public IJavaElement getJavaElement() {
        return this.javaElement;
    }

    public String hName() {
        return this.javaElement.getElementName();
    }

    public IElement hParent() {
        return JavaElement.create(this.javaElement.getParent());
    }

    public IElement hRoot() {
        return JavaElement.create((IJavaElement)this.javaElement.getJavaModel());
    }

    public IResource hResource() {
        return this.javaElement.getResource();
    }

    public IPath hPath() {
        return this.javaElement.getPath();
    }

    public boolean hExists() {
        return this.javaElement.exists();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        JavaElement other = (JavaElement)((Object)obj);
        return this.javaElement.equals(other.javaElement);
    }

    public int hashCode() {
        return this.javaElement.hashCode();
    }

    public String toString() {
        return this.javaElement.toString();
    }

    public String hToString(ToStringStyle style) {
        return this.toString();
    }

    public IElement[] hChildren() throws CoreException {
        if (!(this.javaElement instanceof IParent)) {
            return NO_CHILDREN;
        }
        IJavaElement[] children = ((IParent)this.javaElement).getChildren();
        ArrayList<IElement> result = new ArrayList<IElement>(children.length);
        IJavaElement[] iJavaElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            IElement element = JavaElement.create(child);
            if (element != null) {
                result.add(element);
            }
            ++n2;
        }
        return result.toArray(NO_CHILDREN);
    }
}

