/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.adapter;

import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.TextFileBuffer;
import org.eclipse.handly.internal.examples.adapter.Activator;
import org.eclipse.handly.internal.examples.adapter.JavaSourceElement;
import org.eclipse.handly.model.impl.ISourceFileImpl;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;

class JavaSourceFile
extends JavaSourceElement
implements ISourceFileImpl {
    public JavaSourceFile(ICompilationUnit compilationUnit) {
        super((IJavaElement)compilationUnit);
    }

    public ICompilationUnit getCompilationUnit() {
        return (ICompilationUnit)this.getJavaElement();
    }

    public IFile hFile() {
        return (IFile)this.getCompilationUnit().getResource();
    }

    public boolean hIsWorkingCopy() {
        return this.getCompilationUnit().isWorkingCopy();
    }

    public boolean hNeedsReconciling() {
        try {
            return !this.getCompilationUnit().isConsistent();
        }
        catch (JavaModelException e) {
            Activator.log(e.getStatus());
            return false;
        }
    }

    public void hReconcile(boolean forceProblemDetection, Object arg, IProgressMonitor monitor) throws CoreException {
        this.getCompilationUnit().reconcile(0, forceProblemDetection, null, monitor);
    }

    public IBuffer hBuffer(boolean create, IProgressMonitor monitor) throws CoreException {
        IFile file = this.hFile();
        if (file == null) {
            throw new AssertionError((Object)("No underlying IFile for " + this.toString()));
        }
        if (!create && ITextFileBufferManager.DEFAULT.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE) == null) {
            return null;
        }
        return new TextFileBuffer(file, ITextFileBufferManager.DEFAULT);
    }
}

