/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import java.util.Arrays;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooModel;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.junit.WorkspaceTestCase;

public class FooModelTest
extends WorkspaceTestCase {
    private IFooModel fooModel = FooModelCore.getFooModel();

    protected void setUp() throws Exception {
        super.setUp();
        this.setUpProject("Test001");
        this.setUpProject("SimpleProject");
    }

    public void testFooModel() throws Exception {
        IFooProject[] fooProjects = this.fooModel.getFooProjects();
        FooModelTest.assertEquals((int)1, (int)fooProjects.length);
        IFooProject fooProject = fooProjects[0];
        FooModelTest.assertEquals((String)"Test001", (String)fooProject.getName());
        IFooFile[] fooFiles = fooProject.getFooFiles();
        FooModelTest.assertEquals((int)1, (int)fooFiles.length);
        IFooFile fooFile = fooFiles[0];
        FooModelTest.assertEquals((String)"test.foo", (String)fooFile.getName());
        IResource[] nonFooResources = fooProject.getNonFooResources();
        FooModelTest.assertEquals((int)3, (int)nonFooResources.length);
        IFooProject fooProject2 = this.fooModel.getFooProject("Test002");
        FooModelTest.assertFalse((boolean)fooProject2.exists());
        this.setUpProject("Test002");
        FooModelTest.assertTrue((boolean)fooProject2.exists());
        fooProjects = this.fooModel.getFooProjects();
        FooModelTest.assertEquals((int)2, (int)fooProjects.length);
        FooModelTest.assertTrue((boolean)Arrays.asList(fooProjects).contains(fooProject));
        FooModelTest.assertTrue((boolean)Arrays.asList(fooProjects).contains(fooProject2));
        IFooFile[] fooFiles2 = fooProject2.getFooFiles();
        FooModelTest.assertEquals((int)1, (int)fooFiles2.length);
        IFooFile fooFile2 = fooFiles2[0];
        FooModelTest.assertEquals((String)"test.foo", (String)fooFile2.getName());
        nonFooResources = fooProject2.getNonFooResources();
        FooModelTest.assertEquals((int)1, (int)nonFooResources.length);
        fooFile.getFile().delete(true, null);
        FooModelTest.assertFalse((boolean)fooFile.exists());
        FooModelTest.assertEquals((int)0, (int)fooFile.getParent().getChildren().length);
        fooFile2.getFile().move((IPath)new Path("/Test001/test.foo"), true, null);
        FooModelTest.assertFalse((boolean)fooFile2.exists());
        FooModelTest.assertEquals((int)0, (int)fooProject2.getFooFiles().length);
        FooModelTest.assertEquals((int)1, (int)fooProject.getFooFiles().length);
        fooProject2.getProject().close(null);
        FooModelTest.assertFalse((boolean)fooProject2.exists());
        FooModelTest.assertEquals((int)1, (int)fooProject2.getParent().getChildren().length);
        fooProject2.getProject().open(null);
        FooModelTest.assertTrue((boolean)fooProject2.exists());
        FooModelTest.assertEquals((int)2, (int)fooProject2.getParent().getChildren().length);
        fooProject2.getProject().delete(true, null);
        FooModelTest.assertFalse((boolean)fooProject2.exists());
        FooModelTest.assertEquals((int)1, (int)fooProject2.getParent().getChildren().length);
        IProjectDescription description = fooProject.getProject().getDescription();
        String[] oldNatures = description.getNatureIds();
        description.setNatureIds(new String[0]);
        fooProject.getProject().setDescription(description, null);
        FooModelTest.assertFalse((boolean)fooProject.exists());
        FooModelTest.assertFalse((boolean)fooFile.exists());
        FooModelTest.assertEquals((int)0, (int)this.fooModel.getFooProjects().length);
        description.setNatureIds(oldNatures);
        fooProject.getProject().setDescription(description, null);
        FooModelTest.assertTrue((boolean)fooProject.exists());
        FooModelTest.assertTrue((boolean)fooFile.exists());
        FooModelTest.assertEquals((int)1, (int)this.fooModel.getFooProjects().length);
        fooProject.getProject().move((IPath)new Path("Test"), true, null);
        FooModelTest.assertFalse((boolean)fooProject.exists());
        fooProjects = this.fooModel.getFooProjects();
        FooModelTest.assertEquals((int)1, (int)fooProjects.length);
        fooProject = fooProjects[0];
        FooModelTest.assertEquals((String)"Test", (String)fooProject.getName());
    }
}

