/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.BufferChange;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.SaveMode;
import org.eclipse.handly.buffer.TextFileBuffer;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooDef;
import org.eclipse.handly.examples.basic.ui.model.IFooElement;
import org.eclipse.handly.examples.basic.ui.model.IFooModel;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.examples.basic.ui.model.IFooVar;
import org.eclipse.handly.internal.examples.basic.ui.model.FooFile;
import org.eclipse.handly.junit.WorkspaceTestCase;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.impl.ElementDelta;
import org.eclipse.handly.util.TextRange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class FooWorkingCopyNotificationTest
extends WorkspaceTestCase {
    private FooFile workingCopy;
    private IBuffer buffer;
    private IFooModel fooModel = FooModelCore.getFooModel();
    private FooModelListener listener = new FooModelListener();

    protected void setUp() throws Exception {
        super.setUp();
        IFooProject fooProject = FooModelCore.create((IProject)this.setUpProject("Test002"));
        this.workingCopy = (FooFile)fooProject.getFooFile("test.foo");
        this.fooModel.addElementChangeListener((IElementChangeListener)this.listener);
        this.buffer = new TextFileBuffer(this.workingCopy.getFile(), ITextFileBufferManager.DEFAULT);
    }

    protected void tearDown() throws Exception {
        if (this.buffer != null) {
            this.buffer.release();
        }
        this.fooModel.removeElementChangeListener((IElementChangeListener)this.listener);
        super.tearDown();
    }

    public void test1() throws Exception {
        this.doWithWorkingCopy(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                FooWorkingCopyNotificationTest.assertDelta(FooWorkingCopyNotificationTest.this.newDeltaBuilder((IFooElement)FooWorkingCopyNotificationTest.this.fooModel).changed((IElement)FooWorkingCopyNotificationTest.this.workingCopy, 256L).getDelta(), ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta);
                FooWorkingCopyNotificationTest.this.workingCopy.getFile().touch(null);
                FooWorkingCopyNotificationTest.assertDelta(FooWorkingCopyNotificationTest.this.newDeltaBuilder((IFooElement)FooWorkingCopyNotificationTest.this.fooModel).changed((IElement)FooWorkingCopyNotificationTest.this.workingCopy, 513L).getDelta(), ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta);
                ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta = null;
            }
        });
        FooWorkingCopyNotificationTest.assertDelta(this.newDeltaBuilder((IFooElement)this.fooModel).changed((IElement)this.workingCopy, 256L).getDelta(), this.listener.delta);
    }

    public void test2() throws Exception {
        this.doWithWorkingCopy(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta = null;
                IFooDef[] defs = FooWorkingCopyNotificationTest.this.workingCopy.getDefs();
                FooWorkingCopyNotificationTest.assertEquals((int)3, (int)defs.length);
                IFooDef def = FooWorkingCopyNotificationTest.this.workingCopy.getDef("f", 0);
                FooWorkingCopyNotificationTest.assertEquals((Object)def, (Object)defs[0]);
                TextRange r = defs[0].getSourceElementInfo().getIdentifyingRange();
                BufferChange change = new BufferChange((TextEdit)new ReplaceEdit(r.getOffset(), r.getLength(), "g"));
                change.setSaveMode(SaveMode.LEAVE_UNSAVED);
                FooWorkingCopyNotificationTest.this.buffer.applyChange((IBufferChange)change, null);
                FooWorkingCopyNotificationTest.assertDelta(null, ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta);
                FooWorkingCopyNotificationTest.this.workingCopy.reconcile(false, null);
                FooWorkingCopyNotificationTest.assertFalse((boolean)def.exists());
                FooWorkingCopyNotificationTest.assertDelta(FooWorkingCopyNotificationTest.this.newDeltaBuilder((IFooElement)FooWorkingCopyNotificationTest.this.workingCopy).added((IElement)FooWorkingCopyNotificationTest.this.workingCopy.getDef("g", 0)).removed((IElement)def).getDelta(), ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta);
            }
        });
    }

    public void test3() throws Exception {
        this.doWithWorkingCopy(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta = null;
                IFooVar[] vars = FooWorkingCopyNotificationTest.this.workingCopy.getVars();
                FooWorkingCopyNotificationTest.assertEquals((int)2, (int)vars.length);
                IFooVar varX = FooWorkingCopyNotificationTest.this.workingCopy.getVar("x");
                FooWorkingCopyNotificationTest.assertEquals((Object)varX, (Object)vars[0]);
                IFooVar varY = FooWorkingCopyNotificationTest.this.workingCopy.getVar("y");
                FooWorkingCopyNotificationTest.assertEquals((Object)varY, (Object)vars[1]);
                ISourceElementInfo info = varY.getSourceElementInfo();
                TextRange r = info.getFullRange();
                String varYText = info.getSnapshot().getContents().substring(r.getOffset(), r.getEndOffset());
                BufferChange change = new BufferChange((TextEdit)new DeleteEdit(r.getOffset(), r.getLength()));
                change.setSaveMode(SaveMode.LEAVE_UNSAVED);
                FooWorkingCopyNotificationTest.this.buffer.applyChange((IBufferChange)change, null);
                FooWorkingCopyNotificationTest.assertDelta(null, ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta);
                FooWorkingCopyNotificationTest.this.workingCopy.reconcile(false, null);
                FooWorkingCopyNotificationTest.assertDelta(FooWorkingCopyNotificationTest.this.newDeltaBuilder((IFooElement)FooWorkingCopyNotificationTest.this.workingCopy).removed((IElement)varY).getDelta(), ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta);
                ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta = null;
                info = varX.getSourceElementInfo();
                r = info.getFullRange();
                change = new BufferChange((TextEdit)new InsertEdit(r.getOffset(), varYText));
                change.setSaveMode(SaveMode.LEAVE_UNSAVED);
                FooWorkingCopyNotificationTest.this.buffer.applyChange((IBufferChange)change, null);
                FooWorkingCopyNotificationTest.assertDelta(null, ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta);
                FooWorkingCopyNotificationTest.this.workingCopy.reconcile(false, null);
                FooWorkingCopyNotificationTest.assertDelta(FooWorkingCopyNotificationTest.this.newDeltaBuilder((IFooElement)FooWorkingCopyNotificationTest.this.workingCopy).added((IElement)varY).getDelta(), ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta);
            }
        });
    }

    public void test4() throws Exception {
        this.doWithWorkingCopy(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta = null;
                IFooDef[] defs = FooWorkingCopyNotificationTest.this.workingCopy.getDefs();
                FooWorkingCopyNotificationTest.assertEquals((int)3, (int)defs.length);
                IFooDef def = FooWorkingCopyNotificationTest.this.workingCopy.getDef("f", 1);
                FooWorkingCopyNotificationTest.assertEquals((Object)def, (Object)defs[1]);
                ISourceElementInfo info = def.getSourceElementInfo();
                TextRange r = info.getFullRange();
                BufferChange change = new BufferChange((TextEdit)new ReplaceEdit(r.getOffset(), r.getLength(), "def f(y) {}"));
                change.setSaveMode(SaveMode.LEAVE_UNSAVED);
                FooWorkingCopyNotificationTest.this.buffer.applyChange((IBufferChange)change, null);
                FooWorkingCopyNotificationTest.assertDelta(null, ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta);
                FooWorkingCopyNotificationTest.this.workingCopy.reconcile(false, null);
                FooWorkingCopyNotificationTest.assertDelta(FooWorkingCopyNotificationTest.this.newDeltaBuilder((IFooElement)FooWorkingCopyNotificationTest.this.workingCopy).changed((IElement)def, 1L).getDelta(), ((FooWorkingCopyNotificationTest)FooWorkingCopyNotificationTest.this).listener.delta);
            }
        });
    }

    private void doWithWorkingCopy(IWorkspaceRunnable runnable) throws CoreException {
        this.workingCopy.hBecomeWorkingCopy(this.buffer, null);
        try {
            runnable.run(null);
        }
        finally {
            this.workingCopy.hDiscardWorkingCopy();
        }
    }

    private ElementDelta.Builder newDeltaBuilder(IFooElement element) {
        return new ElementDelta.Builder(new ElementDelta((IElement)element));
    }

    private static void assertDelta(ElementDelta expected, ElementDelta actual) {
        if (expected == null) {
            FooWorkingCopyNotificationTest.assertNull((Object)actual);
            return;
        }
        FooWorkingCopyNotificationTest.assertNotNull((Object)actual);
        FooWorkingCopyNotificationTest.assertEquals((Object)expected.hElement(), (Object)actual.hElement());
        FooWorkingCopyNotificationTest.assertEquals((int)expected.hKind(), (int)actual.hKind());
        FooWorkingCopyNotificationTest.assertEquals((long)expected.hFlags(), (long)actual.hFlags());
        FooWorkingCopyNotificationTest.assertEquals((Object)expected.hMovedToElement(), (Object)actual.hMovedToElement());
        FooWorkingCopyNotificationTest.assertEquals((Object)expected.hMovedFromElement(), (Object)actual.hMovedFromElement());
        ElementDelta[] expectedChildren = expected.hAffectedChildren();
        ElementDelta[] actualChildren = actual.hAffectedChildren();
        FooWorkingCopyNotificationTest.assertEquals((int)expectedChildren.length, (int)actualChildren.length);
        int i = 0;
        while (i < expectedChildren.length) {
            FooWorkingCopyNotificationTest.assertDelta(expectedChildren[i], actualChildren[i]);
            ++i;
        }
    }

    private static class FooModelListener
    implements IElementChangeListener {
        public ElementDelta delta;

        private FooModelListener() {
        }

        public void elementChanged(IElementChangeEvent event) {
            this.delta = (ElementDelta)event.getDelta();
        }
    }
}

