/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.BufferChange;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.SaveMode;
import org.eclipse.handly.buffer.TextFileBuffer;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooDef;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.examples.basic.ui.model.IFooVar;
import org.eclipse.handly.internal.examples.basic.ui.model.FooFile;
import org.eclipse.handly.junit.WorkspaceTestCase;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.impl.Element;
import org.eclipse.handly.model.impl.WorkingCopyInfo;
import org.eclipse.handly.util.TextRange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class FooWorkingCopyTest
extends WorkspaceTestCase {
    private FooFile workingCopy;
    private IBuffer buffer;

    protected void setUp() throws Exception {
        super.setUp();
        IFooProject fooProject = FooModelCore.create((IProject)this.setUpProject("Test002"));
        this.workingCopy = (FooFile)fooProject.getFooFile("test.foo");
        this.buffer = new TextFileBuffer(this.workingCopy.getFile(), ITextFileBufferManager.DEFAULT);
    }

    protected void tearDown() throws Exception {
        if (this.buffer != null) {
            this.buffer.release();
        }
        super.tearDown();
    }

    public void test1() throws Exception {
        this.doWithWorkingCopy(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IFooDef[] defs = FooWorkingCopyTest.this.workingCopy.getDefs();
                FooWorkingCopyTest.assertEquals((int)3, (int)defs.length);
                IFooDef def = FooWorkingCopyTest.this.workingCopy.getDef("f", 0);
                FooWorkingCopyTest.assertEquals((Object)def, (Object)defs[0]);
                TextRange r = defs[0].getSourceElementInfo().getIdentifyingRange();
                BufferChange change = new BufferChange((TextEdit)new ReplaceEdit(r.getOffset(), r.getLength(), "g"));
                change.setSaveMode(SaveMode.LEAVE_UNSAVED);
                FooWorkingCopyTest.this.buffer.applyChange((IBufferChange)change, null);
                defs = FooWorkingCopyTest.this.workingCopy.getDefs();
                FooWorkingCopyTest.assertEquals((int)3, (int)defs.length);
                FooWorkingCopyTest.assertEquals((Object)def, (Object)defs[0]);
                FooWorkingCopyTest.this.workingCopy.reconcile(false, null);
                FooWorkingCopyTest.assertFalse((boolean)def.exists());
                defs = FooWorkingCopyTest.this.workingCopy.getDefs();
                FooWorkingCopyTest.assertEquals((int)3, (int)defs.length);
                FooWorkingCopyTest.assertEquals((Object)FooWorkingCopyTest.this.workingCopy.getDef("g", 0), (Object)defs[0]);
            }
        });
    }

    public void test2() throws Exception {
        this.doWithWorkingCopy(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IFooVar[] vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)2, (int)vars.length);
                IFooVar var1 = FooWorkingCopyTest.this.workingCopy.getVar("x");
                FooWorkingCopyTest.assertEquals((Object)var1, (Object)vars[0]);
                IFooVar var2 = FooWorkingCopyTest.this.workingCopy.getVar("y");
                FooWorkingCopyTest.assertEquals((Object)var2, (Object)vars[1]);
                ISourceElementInfo info = var2.getSourceElementInfo();
                TextRange r = info.getFullRange();
                String var2Text = info.getSnapshot().getContents().substring(r.getOffset(), r.getEndOffset());
                BufferChange change = new BufferChange((TextEdit)new DeleteEdit(r.getOffset(), r.getLength()));
                change.setSaveMode(SaveMode.LEAVE_UNSAVED);
                FooWorkingCopyTest.this.buffer.applyChange((IBufferChange)change, null);
                vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)2, (int)vars.length);
                FooWorkingCopyTest.assertEquals((Object)var2, (Object)vars[1]);
                FooWorkingCopyTest.this.workingCopy.reconcile(false, null);
                FooWorkingCopyTest.assertFalse((boolean)var2.exists());
                vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)1, (int)vars.length);
                FooWorkingCopyTest.assertEquals((Object)var1, (Object)vars[0]);
                info = var1.getSourceElementInfo();
                r = info.getFullRange();
                change = new BufferChange((TextEdit)new InsertEdit(r.getOffset(), var2Text));
                change.setSaveMode(SaveMode.LEAVE_UNSAVED);
                FooWorkingCopyTest.this.buffer.applyChange((IBufferChange)change, null);
                vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)1, (int)vars.length);
                FooWorkingCopyTest.this.workingCopy.reconcile(false, null);
                vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)2, (int)vars.length);
                FooWorkingCopyTest.assertEquals((Object)var2, (Object)vars[0]);
                FooWorkingCopyTest.assertEquals((Object)var1, (Object)vars[1]);
            }
        });
    }

    public void testBug480397_1() throws Exception {
        this.workingCopy.getParent().getResource().delete(true, null);
        this.doWithWorkingCopy(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                FooWorkingCopyTest.assertFalse((boolean)FooWorkingCopyTest.this.workingCopy.getParent().exists());
                FooWorkingCopyTest.assertTrue((boolean)FooWorkingCopyTest.this.workingCopy.exists());
                IFooVar[] vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)2, (int)vars.length);
                IFooDef[] defs = FooWorkingCopyTest.this.workingCopy.getDefs();
                FooWorkingCopyTest.assertEquals((int)3, (int)defs.length);
            }
        });
    }

    public void testBug479623() throws Exception {
        final boolean[] stop = new boolean[1];
        final boolean[] failure = new boolean[1];
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stop[0]) {
                    WorkingCopyInfo info = FooWorkingCopyTest.this.workingCopy.hAcquireWorkingCopy();
                    if (info == null) continue;
                    try {
                        if (info.isInitialized()) continue;
                        failure[0] = true;
                        return;
                    }
                    finally {
                        FooWorkingCopyTest.this.workingCopy.hDiscardWorkingCopy();
                    }
                }
            }
        });
        thread.start();
        try {
            this.doWithWorkingCopy(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                }
            });
            FooWorkingCopyTest.assertFalse((boolean)failure[0]);
            FooWorkingCopyTest.assertTrue((boolean)thread.isAlive());
        }
        finally {
            stop[0] = true;
            thread.join();
        }
    }

    public void testBug480397_2() throws Exception {
        this.doWithWorkingCopy(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                FooWorkingCopyTest.this.workingCopy.hClose();
                FooWorkingCopyTest.assertNotNull((String)"working copy must remain in the cache", (Object)FooWorkingCopyTest.this.workingCopy.hPeekAtBody());
                FooWorkingCopyTest.this.workingCopy.getParent().hClose();
                FooWorkingCopyTest.assertNotNull((String)"working copy must remain in the cache", (Object)FooWorkingCopyTest.this.workingCopy.hPeekAtBody());
            }
        });
    }

    public void testBug480397_3() throws Exception {
        IWorkspaceRunnable testRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IFooDef def = FooWorkingCopyTest.this.workingCopy.getDef("f", 0);
                FooWorkingCopyTest.assertTrue((boolean)def.exists());
                FooWorkingCopyTest.assertFalse((String)"non-openable elements cannot be closed", (boolean)((Element)def).hClose());
                FooWorkingCopyTest.assertNotNull((Object)((Element)def).hPeekAtBody());
            }
        };
        this.doWithWorkingCopy(testRunnable);
        testRunnable.run(null);
    }

    private void doWithWorkingCopy(IWorkspaceRunnable runnable) throws CoreException {
        this.workingCopy.hBecomeWorkingCopy(this.buffer, null);
        try {
            runnable.run(null);
        }
        finally {
            this.workingCopy.hDiscardWorkingCopy();
        }
    }
}

