/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.handly.examples.basic.foo.Module;
import org.eclipse.handly.examples.basic.ui.model.IFooDef;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooVar;
import org.eclipse.handly.internal.examples.basic.ui.Activator;
import org.eclipse.handly.internal.examples.basic.ui.model.FooDef;
import org.eclipse.handly.internal.examples.basic.ui.model.FooFileStructureBuilder;
import org.eclipse.handly.internal.examples.basic.ui.model.FooModelManager;
import org.eclipse.handly.internal.examples.basic.ui.model.FooProject;
import org.eclipse.handly.internal.examples.basic.ui.model.FooVar;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.impl.Element;
import org.eclipse.handly.model.impl.ElementChangeEvent;
import org.eclipse.handly.model.impl.ElementDelta;
import org.eclipse.handly.model.impl.ElementDifferencer;
import org.eclipse.handly.model.impl.ElementManager;
import org.eclipse.handly.model.impl.SourceElementBody;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class FooFile
extends SourceFile
implements IFooFile {
    public FooFile(FooProject parent, IFile file) {
        super((Element)parent, file);
        if (!file.getParent().equals((Object)parent.getProject())) {
            throw new IllegalArgumentException();
        }
        if (!"foo".equals(file.getFileExtension())) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public FooProject getParent() {
        return (FooProject)this.hParent();
    }

    @Override
    public IFooVar getVar(String name) {
        return new FooVar(this, name);
    }

    @Override
    public IFooVar[] getVars() throws CoreException {
        return (IFooVar[])this.getChildren(IFooVar.class);
    }

    @Override
    public IFooDef getDef(String name, int arity) {
        return new FooDef(this, name, arity);
    }

    @Override
    public IFooDef[] getDefs() throws CoreException {
        return (IFooDef[])this.getChildren(IFooDef.class);
    }

    public SourceFile.ReconcileOperation hReconcileOperation() {
        return new NotifyingReconcileOperation();
    }

    protected void hBuildStructure(SourceElementBody body, Map<IElement, Object> newElements, Object ast, String source, IProgressMonitor monitor) {
        EObject root;
        XtextResource resource = (XtextResource)ast;
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null && (root = parseResult.getRootASTElement()) instanceof Module) {
            FooFileStructureBuilder builder = new FooFileStructureBuilder(newElements, resource.getResourceServiceProvider());
            builder.buildStructure(this, body, (Module)root, monitor);
        }
    }

    protected XtextResource hCreateStructuralAst(String source, IProgressMonitor monitor) throws CoreException {
        try {
            return this.parse(source, this.getFile().getCharset());
        }
        catch (IOException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    protected XtextResource parse(String contents, String encoding) throws IOException {
        IResourceSetProvider resourceSetProvider = (IResourceSetProvider)this.getResourceServiceProvider().get(IResourceSetProvider.class);
        ResourceSet resourceSet = resourceSetProvider.get(this.getFile().getProject());
        XtextResource resource = (XtextResource)resourceSet.createResource(this.getResourceUri());
        resource.load((InputStream)new ByteArrayInputStream(contents.getBytes(encoding)), Collections.singletonMap(XtextResource.OPTION_ENCODING, encoding));
        return resource;
    }

    protected IResourceServiceProvider getResourceServiceProvider() {
        IResourceServiceProvider provider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(this.getResourceUri());
        if (provider == null) {
            throw new AssertionError();
        }
        return provider;
    }

    protected URI getResourceUri() {
        return URI.createPlatformResourceURI((String)this.getPath().toString(), (boolean)true);
    }

    protected ElementManager hElementManager() {
        return FooModelManager.INSTANCE.getElementManager();
    }

    protected void hWorkingCopyModeChanged() {
        super.hWorkingCopyModeChanged();
        ElementDelta.Builder builder = new ElementDelta.Builder(new ElementDelta((IElement)this.getRoot()));
        if (this.getFile().exists()) {
            builder.changed((IElement)this, 256L);
        } else if (this.isWorkingCopy()) {
            builder.added((IElement)this, 256L);
        } else {
            builder.removed((IElement)this, 256L);
        }
        FooModelManager.INSTANCE.fireElementChangeEvent((IElementChangeEvent)new ElementChangeEvent(1, (IElementDelta)builder.getDelta()));
    }

    private class NotifyingReconcileOperation
    extends SourceFile.ReconcileOperation {
        private NotifyingReconcileOperation() {
            super((SourceFile)FooFile.this);
        }

        public void reconcile(Object ast, NonExpiringSnapshot snapshot, boolean forced, IProgressMonitor monitor) throws CoreException {
            ElementDifferencer differ = new ElementDifferencer(new ElementDelta.Builder(new ElementDelta((IElement)FooFile.this)));
            super.reconcile(ast, snapshot, forced, monitor);
            differ.buildDelta();
            if (!differ.isEmptyDelta()) {
                FooModelManager.INSTANCE.fireElementChangeEvent((IElementChangeEvent)new ElementChangeEvent(2, differ.getDelta()));
            }
        }
    }
}

