/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.handly.examples.basic.foo.Def;
import org.eclipse.handly.examples.basic.foo.Module;
import org.eclipse.handly.examples.basic.foo.Var;
import org.eclipse.handly.internal.examples.basic.ui.model.FooDef;
import org.eclipse.handly.internal.examples.basic.ui.model.FooFile;
import org.eclipse.handly.internal.examples.basic.ui.model.FooVar;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.SourceElementBody;
import org.eclipse.handly.model.impl.StructureHelper;
import org.eclipse.handly.util.TextRange;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.ITextRegion;

class FooFileStructureBuilder {
    private final StructureHelper helper;
    private final ILocationInFileProvider locationProvider;

    FooFileStructureBuilder(Map<IElement, Object> newElements, IResourceServiceProvider resourceServiceProvider) {
        this.helper = new StructureHelper(newElements);
        if (resourceServiceProvider == null) {
            throw new IllegalArgumentException();
        }
        this.locationProvider = (ILocationInFileProvider)resourceServiceProvider.get(ILocationInFileProvider.class);
    }

    void buildStructure(FooFile handle, SourceElementBody body, Module module, IProgressMonitor monitor) {
        monitor.beginTask("", module.getVars().size() + module.getDefs().size());
        try {
            for (Var var : module.getVars()) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.buildStructure(handle, (Body)body, var);
                monitor.worked(1);
            }
            for (Def def : module.getDefs()) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.buildStructure(handle, (Body)body, def);
                monitor.worked(1);
            }
            this.helper.complete((Body)body);
        }
        finally {
            monitor.done();
        }
    }

    private void buildStructure(FooFile parent, Body parentBody, Var var) {
        if (var.getName() == null || var.getName().isEmpty()) {
            return;
        }
        FooVar handle = new FooVar(parent, var.getName());
        SourceElementBody body = new SourceElementBody();
        body.setFullRange(this.getFullRange((EObject)var));
        body.setIdentifyingRange(this.getIdentifyingRange((EObject)var));
        this.helper.complete((Body)body);
        this.helper.addChild(parentBody, (IElement)handle, (Object)body);
    }

    private void buildStructure(FooFile parent, Body parentBody, Def def) {
        if (def.getName() == null || def.getName().isEmpty()) {
            return;
        }
        int arity = def.getParams().size();
        FooDef handle = new FooDef(parent, def.getName(), arity);
        SourceElementBody body = new SourceElementBody();
        body.setFullRange(this.getFullRange((EObject)def));
        body.setIdentifyingRange(this.getIdentifyingRange((EObject)def));
        body.set(FooDef.PARAMETER_NAMES, (Object)((String[])def.getParams().toArray((Object[])new String[arity])));
        this.helper.complete((Body)body);
        this.helper.addChild(parentBody, (IElement)handle, (Object)body);
    }

    private TextRange getFullRange(EObject eObject) {
        return FooFileStructureBuilder.toTextRange(this.locationProvider.getFullTextRegion(eObject));
    }

    private TextRange getIdentifyingRange(EObject eObject) {
        return FooFileStructureBuilder.toTextRange(this.locationProvider.getSignificantTextRegion(eObject));
    }

    private static TextRange toTextRange(ITextRegion region) {
        if (region == null || region.equals(ITextRegion.EMPTY_REGION)) {
            return null;
        }
        return new TextRange(region.getOffset(), region.getLength());
    }
}

