/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.internal.examples.basic.ui.Activator;
import org.eclipse.handly.internal.examples.basic.ui.model.FooFile;
import org.eclipse.handly.internal.examples.basic.ui.model.FooModel;
import org.eclipse.handly.internal.examples.basic.ui.model.FooModelManager;
import org.eclipse.handly.internal.examples.basic.ui.model.FooProjectBody;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Element;
import org.eclipse.handly.model.impl.ElementManager;

public class FooProject
extends Element
implements IFooProject {
    private final IProject project;

    public FooProject(FooModel parent, IProject project) {
        super((Element)parent, project.getName());
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.project = project;
    }

    @Override
    public void create(IProgressMonitor monitor) throws CoreException {
        this.create(null, monitor);
    }

    @Override
    public void create(final URI location, IProgressMonitor monitor) throws CoreException {
        final IWorkspace workspace = this.getParent().getWorkspace();
        workspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    monitor.beginTask("", 4);
                    IProjectDescription description = workspace.newProjectDescription(FooProject.this.getName());
                    description.setLocationURI(location);
                    FooProject.this.project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    FooProject.this.project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    description.setNatureIds(new String[]{"org.eclipse.xtext.ui.shared.xtextNature", "org.eclipse.handly.examples.basic.ui.fooNature"});
                    FooProject.this.project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    FooProject.this.project.setDefaultCharset("UTF-8", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                finally {
                    monitor.done();
                }
            }
        }, monitor);
    }

    @Override
    public IFooFile getFooFile(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return null;
        }
        String fileExtension = name.substring(lastDot + 1);
        if (!"foo".equals(fileExtension)) {
            return null;
        }
        return new FooFile(this, this.project.getFile(name));
    }

    @Override
    public IFooFile[] getFooFiles() throws CoreException {
        IElement[] children = this.getChildren();
        int length = children.length;
        IFooFile[] result = new IFooFile[length];
        System.arraycopy(children, 0, result, 0, length);
        return result;
    }

    @Override
    public IResource[] getNonFooResources() throws CoreException {
        return ((FooProjectBody)((Object)this.hBody())).getNonFooResources(this);
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public IResource hResource() {
        return this.project;
    }

    protected ElementManager hElementManager() {
        return FooModelManager.INSTANCE.getElementManager();
    }

    protected void hValidateExistence() throws CoreException {
        if (!this.project.exists()) {
            throw new CoreException(Activator.createErrorStatus(MessageFormat.format("Project ''{0}'' does not exist in workspace", this.getName()), null));
        }
        if (!this.project.isOpen()) {
            throw new CoreException(Activator.createErrorStatus(MessageFormat.format("Project ''{0}'' is not open", this.getName()), null));
        }
        if (!this.project.hasNature("org.eclipse.handly.examples.basic.ui.fooNature")) {
            throw new CoreException(Activator.createErrorStatus(MessageFormat.format("Project ''{0}'' does not have the Foo nature", this.getName()), null));
        }
    }

    protected void hBuildStructure(Object body, Map<IElement, Object> newElements, IProgressMonitor monitor) throws CoreException {
        IResource[] members = this.project.members();
        ArrayList<FooFile> fooFiles = new ArrayList<FooFile>(members.length);
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            FooFile fooFile;
            IFile file;
            IResource member = iResourceArray[n2];
            if (member instanceof IFile && "foo".equals((file = (IFile)member).getFileExtension()) && (fooFile = new FooFile(this, file)) != null) {
                fooFiles.add(fooFile);
            }
            ++n2;
        }
        ((Body)body).setChildren(fooFiles.toArray(Body.NO_CHILDREN));
    }

    protected Object hNewBody() {
        return new FooProjectBody();
    }
}

