/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.outline2;

import com.google.inject.Inject;
import java.text.MessageFormat;
import org.eclipse.handly.internal.examples.basic.ui.FooContentProvider;
import org.eclipse.handly.internal.examples.basic.ui.FooLabelProvider;
import org.eclipse.handly.internal.examples.basic.ui.outline2.CompactViewFilter;
import org.eclipse.handly.ui.viewer.ProblemMarkerLabelDecorator;
import org.eclipse.handly.xtext.ui.quickoutline.HandlyXtextOutlinePopup;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FooOutlinePopup
extends HandlyXtextOutlinePopup {
    private boolean compactView;
    @Inject
    private FooContentProvider contentProvider;
    @Inject
    private FooLabelProvider labelProvider;
    @Inject
    private CompactViewFilter compactViewFilter;

    protected ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.labelProvider, (ILabelDecorator)new ProblemMarkerLabelDecorator(), null);
    }

    protected void changeOutlineMode() {
        this.compactView = !this.compactView;
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.getControl().setRedraw(false);
        if (this.getPatternMatcher() == null) {
            TreePath[] treePaths = treeViewer.getExpandedTreePaths();
            this.updateFilter();
            treeViewer.setExpandedTreePaths(treePaths);
        } else {
            this.updateFilter();
            treeViewer.expandAll();
        }
        treeViewer.getControl().setRedraw(true);
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            treeViewer.reveal(selectedElement);
        } else {
            this.selectFirstMatch();
        }
    }

    protected void updateInfoText() {
        KeyStroke invokingKeyStroke = this.getInvokingKeyStroke();
        if (invokingKeyStroke == null) {
            super.updateInfoText();
        } else {
            this.setInfoText(MessageFormat.format(this.compactView ? "Press ''{0}'' to show Full View" : "Press ''{0}'' to show Compact View", invokingKeyStroke.format()));
        }
    }

    private void updateFilter() {
        if (this.compactView) {
            this.getTreeViewer().addFilter((ViewerFilter)this.compactViewFilter);
        } else {
            this.getTreeViewer().removeFilter((ViewerFilter)this.compactViewFilter);
        }
    }
}

