/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.handly.examples.javamodel.ICompilationUnit;
import org.eclipse.handly.examples.javamodel.IJavaElement;
import org.eclipse.handly.examples.javamodel.IJavaModel;
import org.eclipse.handly.examples.javamodel.IJavaProject;
import org.eclipse.handly.examples.javamodel.IPackageFragment;
import org.eclipse.handly.examples.javamodel.IPackageFragmentRoot;
import org.eclipse.handly.examples.javamodel.IType;
import org.eclipse.handly.internal.examples.javamodel.ui.JavaElementContainmentAdapter;
import org.eclipse.handly.internal.examples.javamodel.ui.PersistableJavaElementFactory;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IPersistableElement;

public class JavaElementAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{IResource.class, IPersistableElement.class, IContainmentAdapter.class};
    private static final IContainmentAdapter CONTAINMENT_ADAPTER = new JavaElementContainmentAdapter();

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public Object getAdapter(Object element, Class adapterType) {
        IJavaElement java = (IJavaElement)element;
        if (IResource.class.equals((Object)adapterType)) {
            return this.getResource(java);
        }
        if (IPersistableElement.class.equals((Object)adapterType)) {
            return new PersistableJavaElementFactory(java);
        }
        if (IContainmentAdapter.class.equals((Object)adapterType)) {
            return CONTAINMENT_ADAPTER;
        }
        return null;
    }

    private IResource getResource(IJavaElement element) {
        if (element instanceof IType) {
            IJavaElement parent = element.getParent();
            if (parent instanceof ICompilationUnit) {
                return ((ICompilationUnit)parent).getResource();
            }
        } else {
            if (element instanceof ICompilationUnit) {
                return ((ICompilationUnit)element).getResource();
            }
            if (element instanceof IPackageFragment || element instanceof IPackageFragmentRoot || element instanceof IJavaProject || element instanceof IJavaModel) {
                return element.getResource();
            }
        }
        return null;
    }
}

