/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel.ui.editor;

import org.eclipse.handly.examples.javamodel.JavaModelCore;
import org.eclipse.handly.examples.javamodel.ui.JavaModelContentProvider;
import org.eclipse.handly.examples.javamodel.ui.JavaModelLabelProvider;
import org.eclipse.handly.internal.examples.javamodel.ui.Activator;
import org.eclipse.handly.internal.examples.javamodel.ui.JavaElementComparator;
import org.eclipse.handly.internal.examples.javamodel.ui.JavaInputElementProvider;
import org.eclipse.handly.internal.examples.javamodel.ui.editor.JavaEditor;
import org.eclipse.handly.internal.examples.javamodel.ui.filters.NonPublicMemberFilter;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.ui.outline.ExpandableCheckFiltersContribution;
import org.eclipse.handly.ui.outline.HandlyOutlinePage;
import org.eclipse.handly.ui.outline.IOutlineContribution;
import org.eclipse.handly.ui.outline.LexicalSortActionContribution;
import org.eclipse.handly.ui.outline.LexicalSortContribution;
import org.eclipse.handly.ui.outline.OutlineFilterContribution;
import org.eclipse.handly.ui.outline.ProblemMarkerListenerContribution;
import org.eclipse.handly.ui.outline.ToggleActionContribution;
import org.eclipse.handly.ui.preference.BooleanPreference;
import org.eclipse.handly.ui.preference.FlushingPreferenceStore;
import org.eclipse.handly.ui.preference.IBooleanPreference;
import org.eclipse.handly.ui.viewer.ProblemMarkerLabelDecorator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IEditorPart;

public class JavaOutlinePage
extends HandlyOutlinePage {
    public JavaOutlinePage(IEditorPart editor) {
        this.setInputElementProvider(JavaInputElementProvider.INSTANCE);
        this.init(editor);
    }

    public void dispose() {
        IEditorPart editor = this.getEditor();
        if (editor instanceof JavaEditor) {
            ((JavaEditor)editor).outlinePageClosed();
        }
        super.dispose();
    }

    public IBooleanPreference getLinkWithEditorPreference() {
        return LinkWithEditorPreference.INSTANCE;
    }

    public IBooleanPreference getLexicalSortPreference() {
        return LexicalSortPreference.INSTANCE;
    }

    protected void addOutlineContributions() {
        super.addOutlineContributions();
        this.addOutlineContribution((IOutlineContribution)new ProblemMarkerListenerContribution());
        this.addOutlineContribution((IOutlineContribution)new ExpandableCheckFiltersContribution());
        this.addNonPublicMemberFilterSupport();
    }

    protected void addSortingSupport() {
        this.addOutlineContribution((IOutlineContribution)new LexicalSortActionContribution());
        this.addOutlineContribution((IOutlineContribution)new LexicalSortContribution(){

            protected ViewerComparator getComparator() {
                return new JavaElementComparator();
            }
        });
    }

    protected ITreeContentProvider getContentProvider() {
        return new JavaModelContentProvider();
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new JavaModelLabelProvider(), (ILabelDecorator)new ProblemMarkerLabelDecorator(), null);
    }

    protected void addElementChangeListener(IElementChangeListener listener) {
        JavaModelCore.getJavaModel().addElementChangeListener(listener);
    }

    protected void removeElementChangeListener(IElementChangeListener listener) {
        JavaModelCore.getJavaModel().removeElementChangeListener(listener);
    }

    private void addNonPublicMemberFilterSupport() {
        this.addOutlineContribution((IOutlineContribution)new OutlineFilterContribution(){

            protected IBooleanPreference getPreference() {
                return NonPublicMemberFilterPreference.INSTANCE;
            }

            protected ViewerFilter getFilter() {
                return new NonPublicMemberFilter();
            }
        });
        this.addOutlineContribution((IOutlineContribution)new ToggleActionContribution(){

            protected IBooleanPreference getPreference() {
                return NonPublicMemberFilterPreference.INSTANCE;
            }

            protected void configureAction(IAction action) {
                action.setId("HideNonPublicMembers");
                action.setText("Hide Non-Public Members");
                action.setDescription("Toggles the visibility of non-public memebers");
                action.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.handly.examples.javamodel.ui", (String)"icons/elcl16/public.gif"));
            }
        });
    }

    private static class LexicalSortPreference
    extends BooleanPreference {
        static final LexicalSortPreference INSTANCE = new LexicalSortPreference();

        LexicalSortPreference() {
            super("JavaOutline.LexicalSort", (IPreferenceStore)new FlushingPreferenceStore(Activator.getDefault().getPreferenceStore()));
        }
    }

    private static class LinkWithEditorPreference
    extends BooleanPreference {
        static final LinkWithEditorPreference INSTANCE = new LinkWithEditorPreference();

        LinkWithEditorPreference() {
            super("JavaOutline.LinkWithEditor", (IPreferenceStore)new FlushingPreferenceStore(Activator.getDefault().getPreferenceStore()));
            this.setDefault(true);
        }
    }

    private static class NonPublicMemberFilterPreference
    extends BooleanPreference {
        static final NonPublicMemberFilterPreference INSTANCE = new NonPublicMemberFilterPreference();

        NonPublicMemberFilterPreference() {
            super("JavaOutline.NonPublicMemberFilter", (IPreferenceStore)new FlushingPreferenceStore(Activator.getDefault().getPreferenceStore()));
        }
    }
}

