/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.examples.javamodel.ICompilationUnit;
import org.eclipse.handly.examples.javamodel.IImportContainer;
import org.eclipse.handly.examples.javamodel.IImportDeclaration;
import org.eclipse.handly.examples.javamodel.IJavaSourceElement;
import org.eclipse.handly.examples.javamodel.IPackageDeclaration;
import org.eclipse.handly.examples.javamodel.IType;
import org.eclipse.handly.internal.examples.javamodel.CompilatonUnitStructureBuilder;
import org.eclipse.handly.internal.examples.javamodel.ImportContainer;
import org.eclipse.handly.internal.examples.javamodel.JavaElementDelta;
import org.eclipse.handly.internal.examples.javamodel.JavaModelManager;
import org.eclipse.handly.internal.examples.javamodel.JavaProject;
import org.eclipse.handly.internal.examples.javamodel.JavaWorkingCopyInfo;
import org.eclipse.handly.internal.examples.javamodel.PackageDeclaration;
import org.eclipse.handly.internal.examples.javamodel.PackageFragment;
import org.eclipse.handly.internal.examples.javamodel.ReconcileInfo;
import org.eclipse.handly.internal.examples.javamodel.Type;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.impl.Element;
import org.eclipse.handly.model.impl.ElementChangeEvent;
import org.eclipse.handly.model.impl.ElementDelta;
import org.eclipse.handly.model.impl.ElementDifferencer;
import org.eclipse.handly.model.impl.ElementManager;
import org.eclipse.handly.model.impl.SourceElementBody;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.model.impl.WorkingCopyInfo;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;

public class CompilationUnit
extends SourceFile
implements ICompilationUnit {
    private static final WorkingCopyOwner PRIMARY_OWNER = DefaultWorkingCopyOwner.PRIMARY;
    private static final IImportDeclaration[] NO_IMPORTS = new IImportDeclaration[0];
    private final WorkingCopyOwner owner;

    public CompilationUnit(PackageFragment parent, IFile file, WorkingCopyOwner owner) {
        super((Element)parent, file);
        if (!file.getParent().equals((Object)parent.getResource())) {
            throw new IllegalArgumentException();
        }
        if (!"java".equals(file.getFileExtension())) {
            throw new IllegalArgumentException();
        }
        if (owner == null) {
            owner = PRIMARY_OWNER;
        }
        this.owner = owner;
    }

    @Override
    public PackageFragment getParent() {
        return (PackageFragment)this.hParent();
    }

    @Override
    public IFile getFile() {
        return this.hFile();
    }

    @Override
    public IImportDeclaration getImport(String name) {
        return this.getImportContainer().getImport(name);
    }

    @Override
    public IImportContainer getImportContainer() {
        return new ImportContainer(this);
    }

    @Override
    public IImportDeclaration[] getImports() throws CoreException {
        IImportContainer container = this.getImportContainer();
        if (container.exists()) {
            return container.getImports();
        }
        return NO_IMPORTS;
    }

    @Override
    public IPackageDeclaration getPackageDeclaration(String name) {
        return new PackageDeclaration(this, name);
    }

    @Override
    public IPackageDeclaration[] getPackageDeclarations() throws CoreException {
        return (IPackageDeclaration[])this.getChildren(IPackageDeclaration.class);
    }

    @Override
    public IType getType(String name) {
        return new Type((Element)this, name);
    }

    @Override
    public IType[] getTypes() throws CoreException {
        return (IType[])this.getChildren(IType.class);
    }

    @Override
    public IJavaSourceElement getElementAt(int position, ISnapshot base) throws CoreException {
        return (IJavaSourceElement)this.hSourceElementAt(position, base);
    }

    @Override
    public boolean isWorkingCopy() {
        return this.hIsWorkingCopy();
    }

    @Override
    public org.eclipse.jdt.core.dom.CompilationUnit reconcile(int astLevel, int reconcileFlags, IProgressMonitor monitor) throws CoreException {
        boolean force = (reconcileFlags & 1) != 0;
        ReconcileInfo info = new ReconcileInfo(astLevel, reconcileFlags);
        this.hReconcile(force, info, monitor);
        return info.getAst();
    }

    @Override
    public IBuffer getBuffer() throws CoreException {
        return this.hBuffer();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompilationUnit)) {
            return false;
        }
        CompilationUnit other = (CompilationUnit)obj;
        return this.owner.equals(other.owner) && super.equals(obj);
    }

    public SourceFile.ReconcileOperation hReconcileOperation() {
        return new NotifyingReconcileOperation();
    }

    protected ElementManager hElementManager() {
        return JavaModelManager.INSTANCE.getElementManager();
    }

    protected void hValidateExistence() throws CoreException {
        super.hValidateExistence();
        IStatus status = this.validateCompilationUnitName();
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
    }

    IStatus validateCompilationUnitName() {
        JavaProject javaProject = (JavaProject)this.getAncestor(JavaProject.class);
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        return JavaConventions.validateCompilationUnitName((String)this.getElementName(), (String)sourceLevel, (String)complianceLevel);
    }

    protected Object hCreateStructuralAst(String source, IProgressMonitor monitor) throws CoreException {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setSource(source.toCharArray());
        parser.setUnitName(this.getPath().toString());
        parser.setProject(JavaCore.create((IProject)this.getResource().getProject()));
        parser.setFocalPosition(0);
        return parser.createAST(monitor);
    }

    org.eclipse.jdt.core.dom.CompilationUnit createAst(String source, int astLevel, boolean resolveBindings, boolean enableStatementsRecovery, boolean enableBindingsRecovery, boolean ignoreMethodBodies, IProgressMonitor monitor) throws CoreException {
        ASTParser parser = ASTParser.newParser((int)astLevel);
        parser.setSource(source.toCharArray());
        parser.setUnitName(this.getPath().toString());
        parser.setProject(JavaCore.create((IProject)this.getResource().getProject()));
        parser.setResolveBindings(resolveBindings);
        parser.setStatementsRecovery(enableStatementsRecovery);
        parser.setBindingsRecovery(enableBindingsRecovery);
        parser.setIgnoreMethodBodies(ignoreMethodBodies);
        return (org.eclipse.jdt.core.dom.CompilationUnit)parser.createAST(monitor);
    }

    protected void hBuildStructure(SourceElementBody body, Map<IElement, Object> newElements, Object ast, String source, IProgressMonitor monitor) {
        CompilatonUnitStructureBuilder builder = new CompilatonUnitStructureBuilder(newElements);
        builder.buildStructure(this, body, (org.eclipse.jdt.core.dom.CompilationUnit)ast);
    }

    protected void hWorkingCopyModeChanged() {
        super.hWorkingCopyModeChanged();
        ElementDelta.Builder builder = new ElementDelta.Builder((ElementDelta)new JavaElementDelta(this.getJavaModel()));
        if (this.getFile().exists()) {
            builder.changed((IElement)this, 256L);
        } else if (this.isWorkingCopy()) {
            builder.added((IElement)this, 256L);
        } else {
            builder.removed((IElement)this, 256L);
        }
        JavaModelManager.INSTANCE.fireElementChangeEvent((IElementChangeEvent)new ElementChangeEvent(1, (IElementDelta)builder.getDelta()));
    }

    private class NotifyingReconcileOperation
    extends SourceFile.ReconcileOperation {
        private NotifyingReconcileOperation() {
            super((SourceFile)CompilationUnit.this);
        }

        public void reconcile(Object ast, NonExpiringSnapshot snapshot, boolean forced, IProgressMonitor monitor) throws CoreException {
            ElementDifferencer differ = new ElementDifferencer(new ElementDelta.Builder((ElementDelta)new JavaElementDelta(CompilationUnit.this)));
            super.reconcile(ast, snapshot, forced, monitor);
            this.reportProblems(((org.eclipse.jdt.core.dom.CompilationUnit)ast).getProblems());
            differ.buildDelta();
            if (!differ.isEmptyDelta()) {
                JavaModelManager.INSTANCE.fireElementChangeEvent((IElementChangeEvent)new ElementChangeEvent(2, differ.getDelta()));
            }
        }

        private void reportProblems(IProblem[] problems) {
            if (problems == null || problems.length == 0) {
                return;
            }
            WorkingCopyInfo info = CompilationUnit.this.hPeekAtWorkingCopyInfo();
            if (info instanceof JavaWorkingCopyInfo) {
                this.reportProblems(((JavaWorkingCopyInfo)info).problemRequestor, problems);
            }
        }

        private void reportProblems(IProblemRequestor requestor, IProblem[] problems) {
            if (requestor == null || !requestor.isActive()) {
                return;
            }
            try {
                requestor.beginReporting();
                IProblem[] iProblemArray = problems;
                int n = problems.length;
                int n2 = 0;
                while (n2 < n) {
                    IProblem problem = iProblemArray[n2];
                    requestor.acceptProblem(problem);
                    ++n2;
                }
            }
            finally {
                requestor.endReporting();
            }
        }
    }
}

