/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.examples.javamodel.IImportContainer;
import org.eclipse.handly.examples.javamodel.IImportDeclaration;
import org.eclipse.handly.examples.javamodel.IJavaElement;
import org.eclipse.handly.internal.examples.javamodel.CompilationUnit;
import org.eclipse.handly.internal.examples.javamodel.ImportDeclaration;
import org.eclipse.handly.internal.examples.javamodel.JavaModelManager;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.Element;
import org.eclipse.handly.model.impl.ElementManager;
import org.eclipse.handly.model.impl.SourceConstruct;
import org.eclipse.handly.util.IndentationPolicy;

public class ImportContainer
extends SourceConstruct
implements IImportContainer {
    public ImportContainer(CompilationUnit parent) {
        super((Element)parent, null);
    }

    @Override
    public IImportDeclaration getImport(String name) {
        return new ImportDeclaration(this, name);
    }

    @Override
    public IImportDeclaration[] getImports() throws CoreException {
        IJavaElement[] children = this.getChildren();
        int length = children.length;
        IImportDeclaration[] result = new IImportDeclaration[length];
        System.arraycopy(children, 0, result, 0, length);
        return result;
    }

    protected ElementManager hElementManager() {
        return JavaModelManager.INSTANCE.getElementManager();
    }

    protected void hToStringName(StringBuilder builder) {
        builder.append("<import container>");
    }

    protected void hToString(IndentationPolicy indentationPolicy, int indentationLevel, StringBuilder builder) {
        Object body = this.hPeekAtBody();
        if (body == null) {
            return;
        }
        IElement[] children = this.hChildren(body);
        int i = 0;
        while (i < children.length) {
            if (i > 0) {
                indentationPolicy.appendLineSeparatorTo(builder);
            }
            ((Element)children[i]).hToStringBody(indentationPolicy, indentationLevel, builder);
            ++i;
        }
    }
}

