/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.handly.examples.javamodel.IJavaElement;
import org.eclipse.handly.examples.javamodel.IPackageFragment;
import org.eclipse.handly.examples.javamodel.IPackageFragmentRoot;
import org.eclipse.handly.internal.examples.javamodel.Activator;
import org.eclipse.handly.internal.examples.javamodel.ClasspathUtil;
import org.eclipse.handly.internal.examples.javamodel.JavaModelManager;
import org.eclipse.handly.internal.examples.javamodel.JavaProject;
import org.eclipse.handly.internal.examples.javamodel.PackageFragment;
import org.eclipse.handly.internal.examples.javamodel.PackageFragmentRootBody;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.Element;
import org.eclipse.handly.model.impl.ElementManager;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaConventions;

public class PackageFragmentRoot
extends Element
implements IPackageFragmentRoot {
    private final IResource resource;

    public PackageFragmentRoot(JavaProject parent, IResource resource) {
        super((Element)parent, resource.getName());
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.resource = resource;
    }

    @Override
    public JavaProject getParent() {
        return (JavaProject)this.hParent();
    }

    @Override
    public PackageFragment getPackageFragment(String packageName) {
        return new PackageFragment(this, packageName);
    }

    PackageFragment getPackageFragment(String[] simpleNames) {
        return new PackageFragment(this, simpleNames);
    }

    @Override
    public IPackageFragment[] getPackageFragments() throws CoreException {
        IJavaElement[] children = this.getChildren();
        int length = children.length;
        IPackageFragment[] result = new IPackageFragment[length];
        System.arraycopy(children, 0, result, 0, length);
        return result;
    }

    @Override
    public Object[] getNonJavaResources() throws CoreException {
        return ((PackageFragmentRootBody)((Object)this.hBody())).getNonJavaResources(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageFragmentRoot)) {
            return false;
        }
        PackageFragmentRoot other = (PackageFragmentRoot)o;
        return this.resource.equals((Object)other.resource) && this.getParent().equals(other.getParent());
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public IResource hResource() {
        return this.resource;
    }

    protected ElementManager hElementManager() {
        return JavaModelManager.INSTANCE.getElementManager();
    }

    protected void hValidateExistence() throws CoreException {
        this.validateOnClasspath();
        if (!this.resource.exists()) {
            throw new CoreException(Activator.createErrorStatus(MessageFormat.format("Resource ''{0}'' does not exist", this.resource.getFullPath()), null));
        }
    }

    protected void validateOnClasspath() throws CoreException {
        IClasspathEntry[] rawClasspath = this.getParent().getRawClasspath();
        if (!ClasspathUtil.isSourceFolder(this.resource, rawClasspath)) {
            throw new CoreException(Activator.createErrorStatus(MessageFormat.format("Not a source folder: {0}", this.getPath()), null));
        }
    }

    protected Object hNewBody() {
        return new PackageFragmentRootBody();
    }

    protected void hBuildStructure(Object body, Map<IElement, Object> newElements, IProgressMonitor monitor) throws CoreException {
        if (this.resource.getType() == 2 || this.resource.getType() == 4) {
            IContainer rootFolder = (IContainer)this.resource;
            ArrayList<IPackageFragment> children = new ArrayList<IPackageFragment>();
            this.computeFolderChildren(rootFolder, (IPath)Path.EMPTY, children);
            ((Body)body).setChildren(children.toArray(Body.NO_CHILDREN));
        }
    }

    private void computeFolderChildren(IContainer folder, IPath packagePath, ArrayList<IPackageFragment> children) throws CoreException {
        children.add(new PackageFragment(this, packagePath.segments()));
        IResource[] members = folder.members();
        if (members.length > 0) {
            JavaProject javaProject = this.getParent();
            String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
            String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                String memberName;
                IResource member = iResourceArray[n2];
                if (member instanceof IFolder && JavaConventions.validateIdentifier((String)(memberName = member.getName()), (String)sourceLevel, (String)complianceLevel).getSeverity() != 4) {
                    this.computeFolderChildren((IContainer)((IFolder)member), packagePath.append(memberName), children);
                }
                ++n2;
            }
        }
    }
}

