/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.javamodel;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.examples.javamodel.IField;
import org.eclipse.handly.examples.javamodel.IMethod;
import org.eclipse.handly.examples.javamodel.IType;
import org.eclipse.handly.internal.examples.javamodel.Field;
import org.eclipse.handly.internal.examples.javamodel.Member;
import org.eclipse.handly.internal.examples.javamodel.Method;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.impl.Element;
import org.eclipse.handly.model.impl.SourceElementBody;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.util.IndentationPolicy;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jdt.core.Flags;

public class Type
extends Member
implements IType {
    public Type(Element parent, String name) {
        super(parent, name);
        if (name == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public IField getField(String name) {
        return new Field(this, name);
    }

    @Override
    public IField[] getFields() throws CoreException {
        return (IField[])this.getChildren(IField.class);
    }

    @Override
    public IMethod getMethod(String name, String[] parameterTypes) {
        return new Method(this, name, parameterTypes);
    }

    @Override
    public IMethod[] getMethods() throws CoreException {
        return (IMethod[])this.getChildren(IMethod.class);
    }

    @Override
    public IType getType(String name) {
        return new Type((Element)this, name);
    }

    @Override
    public IType[] getTypes() throws CoreException {
        return (IType[])this.getChildren(IType.class);
    }

    @Override
    public String getSuperclassType() throws CoreException {
        return (String)this.getSourceElementInfo().get(SUPERCLASS_TYPE);
    }

    @Override
    public String[] getSuperInterfaceTypes() throws CoreException {
        String[] result = (String[])this.getSourceElementInfo().get(SUPER_INTERFACE_TYPES);
        if (result == null) {
            return NO_STRINGS;
        }
        return result;
    }

    @Override
    public boolean isClass() throws CoreException {
        int flags = this.getFlags();
        return !Flags.isEnum((int)flags) && !Flags.isInterface((int)flags) && !Flags.isAnnotation((int)flags);
    }

    @Override
    public boolean isEnum() throws CoreException {
        return Flags.isEnum((int)this.getFlags());
    }

    @Override
    public boolean isInterface() throws CoreException {
        return Flags.isInterface((int)this.getFlags());
    }

    @Override
    public boolean isAnnotation() throws CoreException {
        int flags = this.getFlags();
        return Flags.isInterface((int)flags) && Flags.isAnnotation((int)flags);
    }

    @Override
    public boolean isMember() {
        return this.getDeclaringType() != null;
    }

    protected ISourceElement hSourceElementAt(int position, ISourceElementInfo info) throws CoreException {
        ISnapshot snapshot = info.getSnapshot();
        ISourceConstruct[] children = info.getChildren();
        int i = children.length - 1;
        while (i >= 0) {
            ISourceConstruct child = children[i];
            if (child instanceof IField) {
                ISourceElementInfo childInfo = Elements.getSourceElementInfo((ISourceElement)child);
                if (Type.checkInRange((int)position, (ISnapshot)snapshot, (ISourceElementInfo)childInfo)) {
                    ISourceConstruct candidate = null;
                    do {
                        TextRange nameRange;
                        if ((nameRange = childInfo.getIdentifyingRange()) == null || position > nameRange.getEndOffset()) {
                            return candidate == null ? child : candidate;
                        }
                        candidate = child;
                        if (--i < 0) {
                            child = null;
                            continue;
                        }
                        child = children[i];
                        childInfo = Elements.getSourceElementInfo((ISourceElement)child);
                    } while (child != null && Type.checkInRange((int)position, (ISnapshot)snapshot, (ISourceElementInfo)childInfo));
                    return candidate;
                }
            } else {
                ISourceElement found = Elements.getSourceElementAt((ISourceElement)child, (int)position, (ISnapshot)snapshot);
                if (found != null) {
                    return found;
                }
            }
            --i;
        }
        return this;
    }

    protected void hToStringBody(IndentationPolicy indentationPolicy, int indentationLevel, StringBuilder builder, Object body, boolean showResolvedInfo) {
        indentationPolicy.appendIndentTo(builder, indentationLevel);
        if (body != null && body != NO_BODY) {
            SourceElementBody typeBody = (SourceElementBody)body;
            int flags = (Integer)typeBody.get(FLAGS);
            if (Flags.isEnum((int)flags)) {
                builder.append("enum ");
            } else if (Flags.isAnnotation((int)flags)) {
                builder.append("@interface ");
            } else if (Flags.isInterface((int)flags)) {
                builder.append("interface ");
            } else {
                builder.append("class ");
            }
        }
        this.hToStringName(builder);
        if (body == null) {
            builder.append(" (not open)");
        }
    }
}

