/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.text.reconciler;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.model.ElementDeltas;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.ui.IWorkingCopyProvider;
import org.eclipse.handly.ui.text.reconciler.WorkingCopyReconcilingStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class BaseReconciler
extends AbstractReconciler
implements IWorkingCopyProvider {
    private IWorkingCopyProvider provider;
    private IReconcilingStrategy strategy;
    private volatile ISourceFile workingCopy;
    private volatile boolean active = true;
    private volatile boolean modelChanged = false;
    private volatile boolean initialProcessDone = false;
    private final IElementChangeListener elementChangeListener = new IElementChangeListener(){

        public void elementChanged(IElementChangeEvent event) {
            if (BaseReconciler.this.isRunningInReconcilerThread()) {
                return;
            }
            if (BaseReconciler.this.isAffectedBy(event)) {
                BaseReconciler.this.elementChanged(event);
            }
        }
    };
    private ShellListener activationListener;

    public BaseReconciler(IWorkingCopyProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        this.provider = provider;
        this.setIsIncrementalReconciler(false);
        this.setIsAllowedToModifyDocument(false);
        this.setReconcilingStrategy(new WorkingCopyReconcilingStrategy(this));
    }

    public void setReconcilingStrategy(IReconcilingStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException();
        }
        this.strategy = strategy;
        if (strategy instanceof IReconcilingStrategyExtension) {
            IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)strategy;
            extension.setProgressMonitor(this.getProgressMonitor());
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        super.setProgressMonitor(monitor);
        if (this.strategy instanceof IReconcilingStrategyExtension) {
            IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)this.strategy;
            extension.setProgressMonitor(monitor);
        }
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.setWorkingCopy(this.provider.getWorkingCopy());
        this.addElementChangeListener(this.elementChangeListener);
        StyledText control = textViewer.getTextWidget();
        this.activationListener = new ActivationListener((Control)control);
        control.getShell().addShellListener(this.activationListener);
    }

    public void uninstall() {
        StyledText control = this.getTextViewer().getTextWidget();
        if (!control.isDisposed()) {
            control.getShell().removeShellListener(this.activationListener);
        }
        this.activationListener = null;
        this.removeElementChangeListener(this.elementChangeListener);
        super.uninstall();
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return this.strategy;
    }

    @Override
    public ISourceFile getWorkingCopy() {
        return this.workingCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialProcess() {
        Object object = this.getReconcilerLock();
        synchronized (object) {
            if (this.strategy instanceof IReconcilingStrategyExtension) {
                IReconcilingStrategyExtension extension = (IReconcilingStrategyExtension)this.strategy;
                extension.initialReconcile();
            }
        }
        this.initialProcessDone = true;
    }

    protected void process(DirtyRegion dirtyRegion) {
        if (dirtyRegion != null) {
            this.strategy.reconcile(dirtyRegion, (IRegion)dirtyRegion);
        } else {
            IDocument document = this.getDocument();
            if (document != null) {
                this.strategy.reconcile((IRegion)new Region(0, document.getLength()));
            }
        }
    }

    protected void forceReconciling() {
        if (!this.initialProcessDone) {
            return;
        }
        super.forceReconciling();
    }

    protected void reconcilerDocumentChanged(IDocument newDocument) {
        this.setWorkingCopy(this.provider.getWorkingCopy());
        this.strategy.setDocument(newDocument);
    }

    protected Object getReconcilerLock() {
        return this;
    }

    protected abstract void addElementChangeListener(IElementChangeListener var1);

    protected abstract void removeElementChangeListener(IElementChangeListener var1);

    protected boolean isAffectedBy(IElementChangeEvent event) {
        return this.isAffectedBy(event.getDelta(), this.getWorkingCopy());
    }

    protected boolean isAffectedBy(IElementDelta delta, ISourceFile workingCopy) {
        long flags = ElementDeltas.getFlags((IElementDelta)delta);
        if (flags == 2048L || flags == 256L) {
            return false;
        }
        IElement element = ElementDeltas.getElement((IElementDelta)delta);
        if (flags == 512L && element.equals((Object)workingCopy)) {
            return false;
        }
        if (flags == 1024L) {
            if (element.equals((Object)workingCopy)) {
                IMarkerDelta[] iMarkerDeltaArray = ElementDeltas.getMarkerDeltas((IElementDelta)delta);
                int n = iMarkerDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                    if (markerDelta.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
        if (flags != 2L) {
            return true;
        }
        IElementDelta[] iElementDeltaArray = ElementDeltas.getAffectedChildren((IElementDelta)delta);
        int n = iElementDeltaArray.length;
        int n3 = 0;
        while (n3 < n) {
            IElementDelta child = iElementDeltaArray[n3];
            if (this.isAffectedBy(child, workingCopy)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    protected void elementChanged(IElementChangeEvent event) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                BaseReconciler.this.setModelChanged(true);
                if (BaseReconciler.this.isActive()) {
                    BaseReconciler.this.forceReconciling();
                }
            }
        });
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        this.active = active;
        if (Display.getCurrent() == null) {
            throw new AssertionError((Object)"This method can only be executed by the UI thread");
        }
        if (!active) {
            this.setModelChanged(false);
        } else if (this.hasModelChanged()) {
            this.forceReconciling();
        }
    }

    private boolean hasModelChanged() {
        return this.modelChanged;
    }

    private void setModelChanged(boolean modelChanged) {
        this.modelChanged = modelChanged;
    }

    private void setWorkingCopy(ISourceFile workingCopy) {
        this.workingCopy = workingCopy;
    }

    private class ActivationListener
    extends ShellAdapter {
        private final Control control;

        ActivationListener(Control control) {
            if (control == null) {
                throw new IllegalArgumentException();
            }
            this.control = control;
        }

        public void shellActivated(ShellEvent e) {
            if (!this.control.isDisposed() && this.control.isVisible()) {
                BaseReconciler.this.setActive(true);
            }
        }

        public void shellDeactivated(ShellEvent e) {
            if (!this.control.isDisposed() && this.control.getShell() == e.getSource()) {
                BaseReconciler.this.setActive(false);
            }
        }
    }
}

