/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.text.reconciler;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.ui.IWorkingCopyProvider;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class WorkingCopyReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private final IWorkingCopyProvider provider;
    private IProgressMonitor monitor;

    public WorkingCopyReconcilingStrategy(IWorkingCopyProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        this.provider = provider;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public final void initialReconcile() {
        this.reconcile(true);
    }

    public void setDocument(IDocument document) {
    }

    public final void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(false);
    }

    public final void reconcile(IRegion partition) {
        this.reconcile(false);
    }

    protected void reconcile(ISourceFile workingCopy, boolean initialReconcile) throws CoreException {
        Elements.reconcile((ISourceFile)workingCopy, (boolean)true, (IProgressMonitor)this.getProgressMonitor());
    }

    protected final IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    private void reconcile(final boolean initialReconcile) {
        final ISourceFile workingCopy = this.provider.getWorkingCopy();
        if (workingCopy != null) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    WorkingCopyReconcilingStrategy.this.reconcile(workingCopy, initialReconcile);
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }
}

