/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.texteditor;

import java.text.MessageFormat;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.TextFileBuffer;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.IWorkingCopyInfoFactory;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.ui.IInputElementProvider;
import org.eclipse.handly.ui.IWorkingCopyManager;
import org.eclipse.handly.ui.texteditor.Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SourceFileDocumentProvider
extends TextFileDocumentProvider
implements IWorkingCopyManager {
    protected final IInputElementProvider inputElementProvider;

    public SourceFileDocumentProvider(IInputElementProvider inputElementProvider) {
        this(null, inputElementProvider);
    }

    public SourceFileDocumentProvider(IDocumentProvider parent, IInputElementProvider inputElementProvider) {
        super(parent);
        this.inputElementProvider = inputElementProvider;
    }

    @Override
    public ISourceFile getWorkingCopy(IEditorInput editorInput) {
        TextFileDocumentProvider.FileInfo info = this.getFileInfo(editorInput);
        if (info instanceof SourceFileInfo) {
            return ((SourceFileInfo)info).workingCopy;
        }
        return null;
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new SourceFileInfo();
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (!(info instanceof SourceFileInfo)) {
            return null;
        }
        SourceFile sourceFile = this.getSourceFile(element);
        if (sourceFile == null) {
            return null;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TextFileBuffer buffer = new TextFileBuffer(sourceFile.hFile(), ITextFileBufferManager.DEFAULT);){
            if (sourceFile.hBecomeWorkingCopy((IBuffer)buffer, this.getWorkingCopyInfoFactory(sourceFile, element, info), this.getProgressMonitor()) != null) {
                sourceFile.hDiscardWorkingCopy();
                throw new CoreException(Activator.createErrorStatus(MessageFormat.format(Messages.SourceFileDocumentProvider_Working_copy_already_exists__0, sourceFile), null));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((SourceFileInfo)info).workingCopy = sourceFile;
        return info;
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        if (info instanceof SourceFileInfo) {
            ((SourceFileInfo)info).workingCopy.hDiscardWorkingCopy();
        }
        super.disposeFileInfo(element, info);
    }

    protected SourceFile getSourceFile(Object element) {
        if (!(element instanceof IEditorInput)) {
            return null;
        }
        IElement inputElement = this.inputElementProvider.getElement((IEditorInput)element);
        if (!(inputElement instanceof SourceFile)) {
            return null;
        }
        return (SourceFile)inputElement;
    }

    protected IWorkingCopyInfoFactory getWorkingCopyInfoFactory(SourceFile sourceFile, Object element, TextFileDocumentProvider.FileInfo fileInfo) {
        return null;
    }

    protected static class SourceFileInfo
    extends TextFileDocumentProvider.FileInfo {
        SourceFile workingCopy;

        protected SourceFileInfo() {
        }
    }
}

