/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.handly.document.DocumentChange;
import org.eclipse.handly.document.DocumentChangeOperation;
import org.eclipse.handly.document.IDocumentChange;
import org.eclipse.handly.document.UiDocumentChangeRunner;
import org.eclipse.handly.internal.xtext.ui.Activator;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.ISnapshotProvider;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.handly.xtext.ui.editor.IHandlyXtextDocument;
import org.eclipse.handly.xtext.ui.editor.NoXtextResourceException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.ui.editor.DirtyStateEditorSupport;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSource;
import org.eclipse.xtext.ui.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.ITextEditComposer;
import org.eclipse.xtext.ui.editor.reconciler.ReplaceRegion;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class HandlyXtextDocument
extends XtextDocument
implements IHandlyXtextDocument {
    private static final IUnitOfWork.Void<XtextResource> NO_OP = new IUnitOfWork.Void<XtextResource>(){

        public void process(XtextResource resource) {
        }
    };
    private final BooleanThreadLocal hasTopLevelModification = new BooleanThreadLocal();
    private ITextEditComposer composer2;
    private volatile NonExpiringSnapshot reconciledSnapshot;
    private volatile boolean reconcilingWasCanceled;
    private final ThreadLocal<IProgressMonitor> reconcilingMonitor = new ThreadLocal();
    private final ListenerList reconcilingListeners = new ListenerList(1);
    private final DocumentListener selfListener = new DocumentListener();
    private PendingChange pendingChange;
    private final Object pendingChangeLock = new Object();
    private DirtyStateEditorSupport dirtyStateEditorSupport;

    @Inject
    public HandlyXtextDocument(DocumentTokenSource tokenSource, ITextEditComposer composer) {
        super(tokenSource, composer);
        this.composer2 = composer;
        this.addReconcilingListener(new PostReconcileProcessor());
    }

    public void setInput(XtextResource resource) {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        super.setInput(resource);
        this.reconciledSnapshot = this.getNonExpiringSnapshot();
        this.addDocumentListener(this.selfListener);
    }

    public void disposeInput() {
        super.disposeInput();
        this.removeDocumentListener(this.selfListener);
        this.getAndResetPendingChange();
        this.reconciledSnapshot = null;
        this.reconcilingListeners.clear();
    }

    public ISnapshot getSnapshot() {
        return new DocumentSnapshot((IDocument)this);
    }

    @Override
    public ISnapshot getReconciledSnapshot() {
        NonExpiringSnapshot reconciledSnapshot = this.reconciledSnapshot;
        if (reconciledSnapshot == null) {
            return null;
        }
        return reconciledSnapshot.getWrappedSnapshot();
    }

    public void addReconcilingListener(IReconcilingListener listener) {
        this.reconcilingListeners.add((Object)listener);
    }

    public void removeReconcilingListener(IReconcilingListener listener) {
        this.reconcilingListeners.remove((Object)listener);
    }

    @Override
    public boolean needsReconciling() {
        ISnapshot reconciledSnapshot = this.getReconciledSnapshot();
        if (reconciledSnapshot == null) {
            return false;
        }
        return !this.getSnapshot().isEqualTo(reconciledSnapshot) || this.reconcilingWasCanceled;
    }

    @Override
    public void reconcile(boolean force, IProgressMonitor monitor) {
        this.reconcilingMonitor.set(monitor);
        try {
            if (!force) {
                this.readOnly((IUnitOfWork)NO_OP);
            } else {
                T2MReconcilingUnitOfWork reconcilingUnitOfWork = new T2MReconcilingUnitOfWork(true);
                this.internalModify(reconcilingUnitOfWork);
            }
            if (monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
        finally {
            this.reconcilingMonitor.remove();
        }
    }

    public boolean reconcile(IXtextDocumentContentObserver.Processor processor) {
        T2MReconcilingUnitOfWork reconcilingUnitOfWork = new T2MReconcilingUnitOfWork(false);
        return (Boolean)processor.process((IUnitOfWork)reconcilingUnitOfWork);
    }

    @Override
    public <T> T modify(IUnitOfWork<T, XtextResource> work) {
        if (!((Boolean)this.hasTopLevelModification.get()).booleanValue()) {
            work = new M2TReconcilingUnitOfWork<T>(work);
        }
        return (T)this.internalModify(work);
    }

    @Override
    public IDocumentChange applyChange(IDocumentChange change) throws BadLocationException {
        DocumentChangeOperation operation = new DocumentChangeOperation((IDocument)this, change);
        UiDocumentChangeRunner runner = new UiDocumentChangeRunner(UiSynchronizer.DEFAULT, operation);
        return runner.run();
    }

    void setDirtyStateEditorSupport(DirtyStateEditorSupport dirtyStateEditorSupport) {
        this.dirtyStateEditorSupport = dirtyStateEditorSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PendingChange getAndResetPendingChange() {
        PendingChange result;
        Object object = this.pendingChangeLock;
        synchronized (object) {
            result = this.pendingChange;
            this.pendingChange = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDocumentChanged(DocumentEvent event) {
        Object object = this.pendingChangeLock;
        synchronized (object) {
            if (this.pendingChange == null) {
                this.pendingChange = new PendingChange();
            }
            this.pendingChange.add(event);
        }
    }

    private NonExpiringSnapshot getNonExpiringSnapshot() {
        return new NonExpiringSnapshot((ISnapshotProvider)this);
    }

    private void reconciled(final XtextResource resource, final NonExpiringSnapshot snapshot, final boolean forced, final IProgressMonitor monitor) {
        Object[] listeners = this.reconcilingListeners.getListeners();
        monitor.beginTask("", listeners.length);
        try {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                final Object listener = objectArray[n2];
                if (monitor.isCanceled()) break;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        ((IReconcilingListener)listener).reconciled(resource, snapshot, forced, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }

                    public void handleException(Throwable exception) {
                    }
                });
                ++n2;
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void internalReconcile(XtextResource resource) {
        this.reconcile(new InternalProcessor(resource));
    }

    private IProgressMonitor getReconcilingMonitor() {
        IProgressMonitor monitor = this.reconcilingMonitor.get();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }

    private static class BooleanThreadLocal
    extends ThreadLocal<Boolean> {
        private BooleanThreadLocal() {
        }

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            HandlyXtextDocument.this.handleDocumentChanged(event);
        }
    }

    public static interface IReconcilingListener {
        public void reconciled(XtextResource var1, NonExpiringSnapshot var2, boolean var3, IProgressMonitor var4) throws Exception;
    }

    private static class InternalProcessor
    implements IXtextDocumentContentObserver.Processor {
        private final XtextResource resource;

        public InternalProcessor(XtextResource resource) {
            this.resource = resource;
        }

        public <T> T process(IUnitOfWork<T, XtextResource> transaction) {
            try {
                return (T)transaction.exec((Object)this.resource);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
    }

    private class M2TReconcilingUnitOfWork<T>
    implements IUnitOfWork<T, XtextResource> {
        private final IUnitOfWork<T, XtextResource> work;
        private ISnapshot baseSnapshot;

        public M2TReconcilingUnitOfWork(IUnitOfWork<T, XtextResource> work) {
            this.work = work;
        }

        public T exec(XtextResource resource) throws Exception {
            if (resource == null) {
                return (T)this.work.exec((Object)resource);
            }
            HandlyXtextDocument.this.hasTopLevelModification.set(true);
            try {
                Object result;
                HandlyXtextDocument.this.internalReconcile(resource);
                this.baseSnapshot = HandlyXtextDocument.this.getReconciledSnapshot();
                try {
                    EcoreUtil2.resolveAll((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
                    HandlyXtextDocument.this.composer2.beginRecording((Resource)resource);
                    result = this.work.exec((Object)resource);
                    TextEdit edit = HandlyXtextDocument.this.composer2.endRecording();
                    if (edit != null) {
                        DocumentChange change = new DocumentChange(edit);
                        change.setBase(this.baseSnapshot);
                        if (this.work instanceof IHandlyXtextDocument.IUndoableUnitOfWork) {
                            change.setStyle(1);
                        } else {
                            change.setStyle(0);
                        }
                        IDocumentChange undoChange = HandlyXtextDocument.this.applyChange((IDocumentChange)change);
                        if (this.work instanceof IHandlyXtextDocument.IUndoableUnitOfWork) {
                            ((IHandlyXtextDocument.IUndoableUnitOfWork)this.work).acceptUndoChange(undoChange);
                        }
                    }
                }
                catch (Exception e) {
                    Activator.log(Activator.createErrorStatus(e.getMessage(), e));
                    resource.reparse(HandlyXtextDocument.this.reconciledSnapshot.getContents());
                    throw e;
                }
                HandlyXtextDocument.this.internalReconcile(resource);
                Object object = result;
                return (T)object;
            }
            finally {
                HandlyXtextDocument.this.hasTopLevelModification.remove();
            }
        }
    }

    private class PendingChange {
        private NonExpiringSnapshot snapshotToReconcile;
        private ReplaceRegion replaceRegionToReconcile;
        private long modificationStamp;

        private PendingChange() {
        }

        public NonExpiringSnapshot getSnapshotToReconcile() {
            return this.snapshotToReconcile;
        }

        public ReplaceRegion getReplaceRegionToReconcile() {
            return this.replaceRegionToReconcile;
        }

        public long getModificationStamp() {
            return this.modificationStamp;
        }

        public void add(DocumentEvent event) {
            this.snapshotToReconcile = HandlyXtextDocument.this.getNonExpiringSnapshot();
            ReplaceRegion replaceRegion = new ReplaceRegion(event.getOffset(), event.getLength(), event.getText());
            if (this.replaceRegionToReconcile == null) {
                this.replaceRegionToReconcile = replaceRegion;
            } else {
                this.replaceRegionToReconcile.mergeWith(replaceRegion, (Object)this.snapshotToReconcile.getContents());
            }
            this.modificationStamp = event.getModificationStamp();
        }
    }

    private class PostReconcileProcessor
    implements IReconcilingListener {
        private PostReconcileProcessor() {
        }

        @Override
        public void reconciled(XtextResource resource, NonExpiringSnapshot snapshot, boolean forced, final IProgressMonitor monitor) throws Exception {
            CancelIndicator cancelIndicator = new CancelIndicator(){

                public boolean isCanceled() {
                    return monitor.isCanceled();
                }
            };
            monitor.beginTask("", 1);
            try {
                try {
                    EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)cancelIndicator);
                    if (HandlyXtextDocument.this.dirtyStateEditorSupport != null && !monitor.isCanceled()) {
                        HandlyXtextDocument.this.dirtyStateEditorSupport.announceDirtyState(resource);
                    }
                }
                catch (Throwable t) {
                    resource.getCache().clear((Resource)resource);
                    if (!(t instanceof OperationCanceledError)) {
                        Throwables.propagate((Throwable)t);
                    }
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private class T2MReconcilingUnitOfWork
    implements IUnitOfWork<Boolean, XtextResource> {
        private final boolean force;

        public T2MReconcilingUnitOfWork(boolean force) {
            this.force = force;
        }

        public Boolean exec(final XtextResource resource) throws Exception {
            final IProgressMonitor monitor = HandlyXtextDocument.this.getReconcilingMonitor();
            monitor.beginTask("", 2);
            try {
                if (resource == null) {
                    if (this.force) {
                        throw new NoXtextResourceException(HandlyXtextDocument.this);
                    }
                    Boolean bl = false;
                    return bl;
                }
                if (monitor.isCanceled()) {
                    HandlyXtextDocument.this.reconcilingWasCanceled = true;
                    Boolean bl = false;
                    return bl;
                }
                PendingChange change = HandlyXtextDocument.this.getAndResetPendingChange();
                if (change == null) {
                    if (this.force || HandlyXtextDocument.this.reconcilingWasCanceled) {
                        final NonExpiringSnapshot snapshot = HandlyXtextDocument.this.reconciledSnapshot;
                        if (this.force) {
                            resource.update(0, 0, "");
                        }
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void run() throws Exception {
                                HandlyXtextDocument.this.reconciled(resource, snapshot, !HandlyXtextDocument.this.reconcilingWasCanceled, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                            }

                            public void handleException(Throwable exception) {
                            }
                        });
                        HandlyXtextDocument.this.reconcilingWasCanceled = monitor.isCanceled();
                    }
                    Boolean bl = false;
                    return bl;
                }
                final NonExpiringSnapshot snapshot = change.getSnapshotToReconcile();
                ReplaceRegion replaceRegion = change.getReplaceRegionToReconcile();
                long modificationStamp = change.getModificationStamp();
                try {
                    resource.update(replaceRegion.getOffset(), replaceRegion.getLength(), replaceRegion.getText());
                    resource.setModificationStamp(modificationStamp);
                }
                catch (Exception e) {
                    Activator.log(Activator.createErrorStatus(e.getMessage(), e));
                    try {
                        resource.reparse(snapshot.getContents());
                        resource.setModificationStamp(modificationStamp);
                    }
                    catch (Exception e2) {
                        Activator.log(Activator.createErrorStatus(e2.getMessage(), e2));
                        resource.reparse(HandlyXtextDocument.this.reconciledSnapshot.getContents());
                        throw e2;
                    }
                }
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        monitor.worked(1);
                        HandlyXtextDocument.this.reconciled(resource, snapshot, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }

                    public void handleException(Throwable exception) {
                    }
                });
                HandlyXtextDocument.this.reconcilingWasCanceled = monitor.isCanceled();
                HandlyXtextDocument.this.reconciledSnapshot = snapshot;
                Boolean bl = true;
                return bl;
            }
            finally {
                monitor.done();
            }
        }
    }
}

