/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.internal.xtext.ui.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.SourceFile;
import org.eclipse.handly.ui.IInputElementProvider;
import org.eclipse.handly.ui.texteditor.TextEditorBuffer;
import org.eclipse.handly.util.TextRange;
import org.eclipse.handly.xtext.ui.editor.XtextWorkingCopyInfo;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.ui.editor.IXtextEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;

@Singleton
public class HandlyXtextEditorCallback
extends IXtextEditorCallback.NullImpl {
    private IInputElementProvider inputElementProvider;
    private Map<XtextEditor, WorkingCopyInfo> workingCopies = new HashMap<XtextEditor, WorkingCopyInfo>();
    private Map<MultiPageEditorPart, Set<XtextEditor>> nestedEditors = new HashMap<MultiPageEditorPart, Set<XtextEditor>>();
    private Map<XtextEditor, IPartListener> partListeners = new HashMap<XtextEditor, IPartListener>();
    private Map<XtextEditor, ISelectionChangedListener> selectionListeners = new HashMap<XtextEditor, ISelectionChangedListener>();
    private Map<XtextEditor, HighlightRangeJob> highlightRangeJobs = new HashMap<XtextEditor, HighlightRangeJob>();

    @Inject
    public void setInputElementProvider(IInputElementProvider provider) {
        this.inputElementProvider = provider;
    }

    public void afterCreatePartControl(XtextEditor editor) {
        this.registerContainer(editor);
        this.registerPartListener(editor);
        this.registerSelectionListener(editor);
    }

    public void beforeDispose(XtextEditor editor) {
        this.deregisterPartListener(editor);
        this.deregisterSelectionListener(editor);
        this.disconnectWorkingCopy(editor);
        this.disposeHighlightRangeJob(editor);
        this.deregisterContainer(editor);
    }

    public void beforeSetInput(XtextEditor editor) {
        this.disconnectWorkingCopy(editor);
    }

    public void afterSetInput(XtextEditor editor) {
        if (this.isActive(editor)) {
            this.connectWorkingCopy(editor);
        }
    }

    protected void afterSelectionChange(XtextEditor editor, ISelection selection) {
        this.setHighlightRange(editor, selection);
    }

    protected void setHighlightRange(XtextEditor editor, ISelection selection) {
        if (selection == null) {
            return;
        }
        SourceFile sourceFile = this.getWorkingCopy(editor);
        if (sourceFile == null) {
            return;
        }
        this.scheduleHighlightRangeJob(editor, sourceFile, selection);
    }

    protected SourceFile getSourceFile(XtextEditor editor) {
        IElement inputElement = this.inputElementProvider.getElement(editor.getEditorInput());
        if (!(inputElement instanceof SourceFile)) {
            return null;
        }
        return (SourceFile)inputElement;
    }

    protected final SourceFile getWorkingCopy(XtextEditor editor) {
        WorkingCopyInfo workingCopyInfo = this.workingCopies.get(editor);
        if (workingCopyInfo == null || !workingCopyInfo.success) {
            return null;
        }
        return workingCopyInfo.sourceFile;
    }

    private boolean isActive(XtextEditor editor) {
        IEditorSite site = editor.getEditorSite();
        if (site == null) {
            return false;
        }
        IEditorPart activeEditor = site.getPage().getActiveEditor();
        return editor == activeEditor || activeEditor != null && this.getContainer(editor) == activeEditor;
    }

    private MultiPageEditorPart getContainer(XtextEditor editor) {
        MultiPageEditorPart container = null;
        IEditorSite site = editor.getEditorSite();
        while (site instanceof MultiPageEditorSite) {
            container = ((MultiPageEditorSite)site).getMultiPageEditor();
            site = container.getEditorSite();
        }
        return container;
    }

    private void registerContainer(XtextEditor editor) {
        MultiPageEditorPart container = this.getContainer(editor);
        if (container == null) {
            return;
        }
        Set<XtextEditor> nestedSet = this.nestedEditors.get(container);
        if (nestedSet == null) {
            nestedSet = new HashSet<XtextEditor>();
            this.nestedEditors.put(container, nestedSet);
        }
        nestedSet.add(editor);
    }

    private void deregisterContainer(XtextEditor editor) {
        MultiPageEditorPart container = this.getContainer(editor);
        if (container == null) {
            return;
        }
        Set<XtextEditor> nestedSet = this.nestedEditors.get(container);
        if (nestedSet != null) {
            nestedSet.remove(editor);
            if (nestedSet.isEmpty()) {
                this.nestedEditors.remove(container);
            }
        }
    }

    private void registerPartListener(final XtextEditor editor) {
        IPartListener listener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (part == editor || part == HandlyXtextEditorCallback.this.getContainer(editor)) {
                    HandlyXtextEditorCallback.this.connectWorkingCopy(editor);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                this.partActivated(part);
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }
        };
        editor.getSite().getWorkbenchWindow().getPartService().addPartListener(listener);
        this.partListeners.put(editor, listener);
    }

    private void deregisterPartListener(XtextEditor editor) {
        IPartListener listener = this.partListeners.remove(editor);
        if (listener != null) {
            editor.getSite().getWorkbenchWindow().getPartService().removePartListener(listener);
        }
    }

    private void registerSelectionListener(final XtextEditor editor) {
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HandlyXtextEditorCallback.this.afterSelectionChange(editor, event.getSelection());
            }
        };
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener(listener);
        } else {
            selectionProvider.addSelectionChangedListener(listener);
        }
        this.selectionListeners.put(editor, listener);
    }

    private void deregisterSelectionListener(XtextEditor editor) {
        ISelectionChangedListener listener = this.selectionListeners.remove(editor);
        if (listener != null) {
            ISelectionProvider selectionProvider = editor.getSelectionProvider();
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener(listener);
            } else {
                selectionProvider.removeSelectionChangedListener(listener);
            }
        }
    }

    private void connectWorkingCopy(XtextEditor editor) {
        SourceFile sourceFile = this.getSourceFile(editor);
        if (sourceFile == null) {
            return;
        }
        XtextEditor workingCopyEditor = this.getWorkingCopyEditor(sourceFile);
        if (editor != workingCopyEditor) {
            if (workingCopyEditor != null) {
                this.discardWorkingCopy(workingCopyEditor);
            }
            this.createWorkingCopy(sourceFile, editor);
        }
    }

    private void disconnectWorkingCopy(XtextEditor editor) {
        SourceFile sourceFile = this.discardWorkingCopy(editor);
        if (sourceFile == null) {
            return;
        }
        XtextEditor mruClone = this.findMruClone(editor);
        if (mruClone != null) {
            this.createWorkingCopy(sourceFile, mruClone);
        }
    }

    private void createWorkingCopy(SourceFile sourceFile, XtextEditor editor) {
        block12: {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (TextEditorBuffer buffer = new TextEditorBuffer((ITextEditor)editor);){
                    if (sourceFile.hBecomeWorkingCopy((IBuffer)buffer, b -> new XtextWorkingCopyInfo(b), null) != null) {
                        sourceFile.hDiscardWorkingCopy();
                        throw new IllegalStateException("Already a working copy: " + sourceFile);
                    }
                    this.workingCopies.put(editor, new WorkingCopyInfo(sourceFile, true));
                    this.setHighlightRange(editor, editor.getSelectionProvider().getSelection());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CoreException e) {
                this.workingCopies.put(editor, new WorkingCopyInfo(sourceFile, false));
                editor.resetHighlightRange();
                if (!editor.getEditorInput().exists()) break block12;
                Activator.log(e.getStatus());
            }
        }
    }

    private SourceFile discardWorkingCopy(XtextEditor editor) {
        WorkingCopyInfo workingCopyInfo = this.workingCopies.remove(editor);
        if (workingCopyInfo == null) {
            return null;
        }
        if (workingCopyInfo.success) {
            workingCopyInfo.sourceFile.hDiscardWorkingCopy();
            editor.resetHighlightRange();
        }
        return workingCopyInfo.sourceFile;
    }

    private XtextEditor getWorkingCopyEditor(SourceFile sourceFile) {
        Set<Map.Entry<XtextEditor, WorkingCopyInfo>> entrySet = this.workingCopies.entrySet();
        for (Map.Entry<XtextEditor, WorkingCopyInfo> entry : entrySet) {
            if (!entry.getValue().sourceFile.equals((Object)sourceFile)) continue;
            return entry.getKey();
        }
        return null;
    }

    private XtextEditor findMruClone(XtextEditor editor) {
        IEditorReference[] references;
        IEditorInput editorInput = editor.getEditorInput();
        IEditorReference[] iEditorReferenceArray = references = editor.getSite().getPage().findEditors(editorInput, null, 1);
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            Set<XtextEditor> nestedSet;
            IEditorReference reference = iEditorReferenceArray[n2];
            IEditorPart candidate = reference.getEditor(false);
            if (candidate instanceof XtextEditor) {
                if (candidate != editor) {
                    return (XtextEditor)candidate;
                }
            } else if (candidate instanceof MultiPageEditorPart && (nestedSet = this.nestedEditors.get(candidate)) != null) {
                for (XtextEditor nested : nestedSet) {
                    if (nested == editor || !editorInput.equals(nested.getEditorInput())) continue;
                    return nested;
                }
            }
            ++n2;
        }
        return null;
    }

    private void scheduleHighlightRangeJob(XtextEditor editor, SourceFile sourceFile, ISelection selection) {
        HighlightRangeJob highlightRangeJob = this.highlightRangeJobs.get(editor);
        if (highlightRangeJob == null) {
            highlightRangeJob = new HighlightRangeJob(editor);
            this.highlightRangeJobs.put(editor, highlightRangeJob);
        }
        highlightRangeJob.cancel();
        highlightRangeJob.setArgs(new HighlightArgs(sourceFile, selection));
        highlightRangeJob.schedule();
    }

    private void disposeHighlightRangeJob(XtextEditor editor) {
        HighlightRangeJob highlightRangeJob = this.highlightRangeJobs.remove(editor);
        if (highlightRangeJob != null) {
            highlightRangeJob.cancel();
            highlightRangeJob.setArgs(null);
        }
    }

    private static class HighlightArgs {
        public final SourceFile sourceFile;
        public final ISelection selection;

        public HighlightArgs(SourceFile sourceFile, ISelection selection) {
            this.sourceFile = sourceFile;
            this.selection = selection;
        }
    }

    private class HighlightRangeJob
    extends Job {
        private final XtextEditor editor;
        private volatile HighlightArgs args;

        public HighlightRangeJob(XtextEditor editor) {
            super("");
            this.setSystem(true);
            this.editor = editor;
        }

        public void setArgs(HighlightArgs args) {
            this.args = args;
        }

        protected IStatus run(IProgressMonitor monitor) {
            int position;
            HighlightArgs args = this.args;
            if (args == null) {
                return Status.OK_STATUS;
            }
            SourceFile sourceFile = args.sourceFile;
            ISelection selection = args.selection;
            ISourceElement selectedElement = null;
            if (selection instanceof ITextSelection && (position = ((ITextSelection)selection).getOffset()) >= 0) {
                try {
                    Elements.reconcile((ISourceFile)sourceFile, (boolean)false, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    Activator.log(e.getStatus());
                    this.resetEditorHighlightRange(args);
                    return e.getStatus();
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    selectedElement = Elements.getSourceElementAt((ISourceElement)sourceFile, (int)position, null);
                    if (sourceFile.equals((Object)selectedElement)) {
                        selectedElement = null;
                    }
                }
                catch (CoreException e) {
                    selectedElement = null;
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (selectedElement == null || !Elements.exists(selectedElement)) {
                this.resetEditorHighlightRange(args);
            } else {
                TextRange r;
                try {
                    r = Elements.getSourceElementInfo(selectedElement).getFullRange();
                }
                catch (CoreException e) {
                    Activator.log(e.getStatus());
                    this.resetEditorHighlightRange(args);
                    return e.getStatus();
                }
                if (r != null) {
                    this.setEditorHighlightRange(args, r.getOffset(), r.getLength());
                }
            }
            return Status.OK_STATUS;
        }

        private void setEditorHighlightRange(final HighlightArgs args, final int offset, final int length) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!HighlightRangeJob.this.hasWorldChanged(args)) {
                        HighlightRangeJob.this.editor.setHighlightRange(offset, length, false);
                    }
                }
            });
        }

        private void resetEditorHighlightRange(final HighlightArgs args) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!HighlightRangeJob.this.hasWorldChanged(args)) {
                        HighlightRangeJob.this.editor.resetHighlightRange();
                    }
                }
            });
        }

        private boolean hasWorldChanged(HighlightArgs baseArgs) {
            return baseArgs != this.args || !baseArgs.sourceFile.equals((Object)HandlyXtextEditorCallback.this.getWorkingCopy(this.editor)) || !baseArgs.selection.equals(this.editor.getSelectionProvider().getSelection());
        }
    }

    private static class WorkingCopyInfo {
        public final SourceFile sourceFile;
        public final boolean success;

        public WorkingCopyInfo(SourceFile sourceFile, boolean success) {
            this.sourceFile = sourceFile;
            this.success = success;
        }
    }
}

