/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.internal.xtext.ui.Activator;
import org.eclipse.handly.model.impl.WorkingCopyInfo;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.handly.xtext.ui.editor.HandlyXtextDocument;
import org.eclipse.handly.xtext.ui.editor.NoXtextResourceException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.resource.XtextResource;

public class XtextWorkingCopyInfo
extends WorkingCopyInfo {
    private final HandlyXtextDocument.IReconcilingListener reconcilingListener = new HandlyXtextDocument.IReconcilingListener(){

        @Override
        public void reconciled(XtextResource resource, NonExpiringSnapshot snapshot, boolean forced, IProgressMonitor monitor) throws Exception {
            XtextWorkingCopyInfo.this.getWorkingCopy().hReconcileOperation().reconcile((Object)resource, snapshot, forced, monitor);
        }
    };

    public XtextWorkingCopyInfo(IBuffer buffer) {
        super(buffer);
        IDocument document = buffer.getDocument();
        if (!(document instanceof HandlyXtextDocument)) {
            throw new IllegalArgumentException();
        }
    }

    protected void onInit() throws CoreException {
        super.onInit();
        this.getDocument().addReconcilingListener(this.reconcilingListener);
    }

    protected void onDispose() {
        this.getDocument().removeReconcilingListener(this.reconcilingListener);
        super.onDispose();
    }

    protected boolean needsReconciling() {
        return this.getDocument().needsReconciling();
    }

    protected void reconcile(boolean force, Object arg, IProgressMonitor monitor) throws CoreException {
        try {
            this.getDocument().reconcile(force, monitor);
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (NoXtextResourceException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    protected HandlyXtextDocument getDocument() {
        return (HandlyXtextDocument)this.getBuffer().getDocument();
    }
}

