/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.BufferChange;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.SaveMode;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.text.edits.UndoEdit;

public class BufferChangeOperation {
    protected final IBuffer buffer;
    protected final IBufferChange change;

    public BufferChangeOperation(IBuffer buffer, IBufferChange change) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        if (buffer.getDocument() == null) {
            throw new IllegalArgumentException();
        }
        if (change == null) {
            throw new IllegalArgumentException();
        }
        this.buffer = buffer;
        this.change = change;
    }

    public IBufferChange execute(IProgressMonitor monitor) throws CoreException, BadLocationException {
        IDocument document = this.buffer.getDocument();
        if (document == null) {
            throw new IllegalStateException();
        }
        if (!(document instanceof IDocumentExtension4)) {
            return this.applyChange(monitor);
        }
        IDocumentExtension4 extension = (IDocumentExtension4)document;
        boolean isLargeEdit = RewriteSessionEditProcessor.isLargeEdit((TextEdit)this.change.getEdit());
        DocumentRewriteSessionType type = isLargeEdit ? DocumentRewriteSessionType.UNRESTRICTED : DocumentRewriteSessionType.UNRESTRICTED_SMALL;
        DocumentRewriteSession session = extension.startRewriteSession(type);
        try {
            IBufferChange iBufferChange = this.applyChange(monitor);
            return iBufferChange;
        }
        finally {
            extension.stopRewriteSession(session);
        }
    }

    protected IBufferChange applyChange(IProgressMonitor pm) throws CoreException, BadLocationException {
        this.checkChange();
        IDocument document = this.buffer.getDocument();
        LinkedModeModel.closeAllModels((IDocument)document);
        boolean saved = !this.buffer.hasUnsavedChanges();
        long stampToRestore = BufferChangeOperation.getModificationStampOf(document);
        UndoEdit undoEdit = this.applyTextEdit();
        if (this.change instanceof UndoChange) {
            BufferChangeOperation.setModificationStampOf(document, ((UndoChange)this.change).stampToRestore);
        }
        if (this.change.getSaveMode() == SaveMode.FORCE_SAVE || saved && this.change.getSaveMode() == SaveMode.KEEP_SAVED_STATE) {
            this.buffer.save(false, pm);
        }
        return this.createUndoChange(undoEdit, stampToRestore);
    }

    protected void checkChange() throws CoreException {
        ISnapshot base = this.change.getBase();
        if (base != null && !base.isEqualTo(this.buffer.getSnapshot())) {
            throw new StaleSnapshotException();
        }
    }

    protected UndoEdit applyTextEdit() throws BadLocationException {
        return this.createTextEditProcessor().performEdits();
    }

    protected TextEditProcessor createTextEditProcessor() {
        return new ChangeEditProcessor();
    }

    protected IBufferChange createUndoChange(UndoEdit undoEdit, long stampToRestore) {
        if (undoEdit == null) {
            return null;
        }
        UndoChange undoChange = new UndoChange((TextEdit)undoEdit, stampToRestore);
        undoChange.setBase(this.buffer.getSnapshot());
        undoChange.setStyle(this.change.getStyle());
        undoChange.setSaveMode(this.change.getSaveMode());
        return undoChange;
    }

    protected static long getModificationStampOf(IDocument document) {
        long modificationStamp = -1L;
        if (document instanceof IDocumentExtension4) {
            modificationStamp = ((IDocumentExtension4)document).getModificationStamp();
        }
        return modificationStamp;
    }

    protected static void setModificationStampOf(IDocument document, long modificationStamp) {
        if (document instanceof IDocumentExtension4 && modificationStamp != -1L) {
            try {
                ((IDocumentExtension4)document).replace(0, 0, "", modificationStamp);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected class ChangeEditProcessor
    extends TextEditProcessor {
        public ChangeEditProcessor() {
            super(BufferChangeOperation.this.buffer.getDocument(), BufferChangeOperation.this.change.getEdit(), BufferChangeOperation.this.change.getStyle());
        }

        protected boolean considerEdit(TextEdit edit) {
            return BufferChangeOperation.this.change.contains(edit);
        }
    }

    protected static class UndoChange
    extends BufferChange {
        public final long stampToRestore;

        public UndoChange(TextEdit undoEdit, long stampToRestore) {
            super(undoEdit);
            this.stampToRestore = stampToRestore;
        }
    }
}

