/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.SimpleBuffer;

public class ChildBuffer
extends SimpleBuffer {
    private final IBuffer parent;

    public ChildBuffer(IBuffer parent) {
        super(parent.getContents());
        this.parent = parent;
        parent.addRef();
    }

    @Override
    public synchronized void addRef() {
        super.addRef();
        this.parent.addRef();
    }

    @Override
    public synchronized void release() {
        this.parent.release();
        super.release();
    }

    @Override
    protected void doSave(boolean overwrite, IProgressMonitor monitor) throws CoreException {
        String parentContents = this.parent.getContents();
        boolean saved = false;
        try {
            this.parent.setContents(this.getContents());
            this.parent.save(overwrite, monitor);
            saved = true;
        }
        finally {
            if (!saved) {
                this.parent.setContents(parentContents);
            }
        }
    }

    protected final IBuffer getParent() {
        return this.parent;
    }
}

