/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.handly.buffer.BufferChangeOperation;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.text.edits.MalformedTreeException;

public class SimpleBuffer
implements IBuffer {
    private final IDocument document = this.createEmptyDocument();
    private volatile long synchronizationStamp;

    public SimpleBuffer() {
        this(null);
    }

    public SimpleBuffer(String contents) {
        if (contents != null && !contents.isEmpty()) {
            this.document.set(contents);
        }
        this.synchronizationStamp = ((IDocumentExtension4)this.document).getModificationStamp();
    }

    @Override
    public IDocument getDocument() {
        return this.document;
    }

    @Override
    public ISnapshot getSnapshot() {
        return new DocumentSnapshot(this.document);
    }

    @Override
    public IBufferChange applyChange(IBufferChange change, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            BufferChangeOperation operation = new BufferChangeOperation(this, change);
            return operation.execute(monitor);
        }
        catch (MalformedTreeException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
        catch (BadLocationException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    @Override
    public void setContents(String contents) {
        this.document.set(contents);
    }

    @Override
    public String getContents() {
        return this.document.get();
    }

    @Override
    public boolean hasUnsavedChanges() {
        return ((IDocumentExtension4)this.document).getModificationStamp() != this.synchronizationStamp;
    }

    @Override
    public boolean mustSaveChanges() {
        return this.hasUnsavedChanges();
    }

    @Override
    public synchronized void save(boolean overwrite, IProgressMonitor monitor) throws CoreException {
        this.doSave(overwrite, monitor);
        this.synchronizationStamp = ((IDocumentExtension4)this.document).getModificationStamp();
    }

    @Override
    public void addRef() {
    }

    @Override
    public void release() {
    }

    protected IDocument createEmptyDocument() {
        IDocument document = ITextFileBufferManager.DEFAULT.createEmptyDocument(null, LocationKind.NORMALIZE);
        ((ISynchronizable)document).setLockObject(new Object());
        return document;
    }

    protected void doSave(boolean overwrite, IProgressMonitor monitor) throws CoreException {
    }
}

