/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.handly.buffer.BufferChangeOperation;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.UiBufferChangeRunner;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.TextFileBufferSnapshot;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;

public class TextFileBuffer
implements IBuffer {
    private final IFile file;
    private final ITextFileBufferManager bufferManager;
    private ITextFileBuffer delegate;
    private int refCount = 1;

    public TextFileBuffer(IFile file, ITextFileBufferManager bufferManager) throws CoreException {
        this.file = file;
        if (this.file == null) {
            throw new IllegalArgumentException();
        }
        this.bufferManager = bufferManager;
        if (this.bufferManager == null) {
            throw new IllegalArgumentException();
        }
        bufferManager.connect(file.getFullPath(), LocationKind.IFILE, null);
        this.delegate = bufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (this.delegate == null) {
            throw new AssertionError();
        }
    }

    @Override
    public IDocument getDocument() {
        return this.getDelegate().getDocument();
    }

    @Override
    public ISnapshot getSnapshot() {
        return new TextFileBufferSnapshot(this.getDelegate(), this.bufferManager);
    }

    @Override
    public IBufferChange applyChange(IBufferChange change, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            BufferChangeOperation operation = new BufferChangeOperation(this, change);
            if (!this.getDelegate().isSynchronizationContextRequested()) {
                return operation.execute(monitor);
            }
            UiBufferChangeRunner runner = new UiBufferChangeRunner(UiSynchronizer.DEFAULT, operation);
            return runner.run(monitor);
        }
        catch (MalformedTreeException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
        catch (BadLocationException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    @Override
    public void setContents(String contents) {
        this.getDocument().set(contents);
    }

    @Override
    public String getContents() {
        return this.getDocument().get();
    }

    @Override
    public boolean hasUnsavedChanges() {
        return this.getDelegate().isDirty();
    }

    @Override
    public boolean mustSaveChanges() {
        ITextFileBuffer delegate = this.getDelegate();
        return delegate.isDirty() && !delegate.isShared();
    }

    @Override
    public void save(boolean overwrite, IProgressMonitor monitor) throws CoreException {
        this.getDelegate().commit(monitor, overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRef() {
        TextFileBuffer textFileBuffer = this;
        synchronized (textFileBuffer) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        TextFileBuffer textFileBuffer = this;
        synchronized (textFileBuffer) {
            if (--this.refCount != 0) {
                return;
            }
            if (this.delegate == null) {
                return;
            }
            this.delegate = null;
        }
        try {
            this.bufferManager.disconnect(this.file.getFullPath(), LocationKind.IFILE, null);
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
    }

    protected final ITextFileBuffer getDelegate() {
        ITextFileBuffer result = this.delegate;
        if (result == null) {
            throw new IllegalStateException("Attempt to access a disconnected TextFileBuffer for " + this.file.getFullPath());
        }
        return result;
    }
}

