/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model;

import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.ToStringStyle;
import org.eclipse.handly.model.impl.IElementImpl;
import org.eclipse.handly.model.impl.ISourceElementImpl;
import org.eclipse.handly.model.impl.ISourceFileImpl;
import org.eclipse.handly.model.impl.SimpleSourceElementInfo;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;

public class Elements {
    public static final ISourceElementInfo NO_SOURCE_INFO = new SimpleSourceElementInfo();

    public static String getName(IElement element) {
        return ((IElementImpl)element).hName();
    }

    public static IElement getParent(IElement element) {
        return ((IElementImpl)element).hParent();
    }

    public static IElement getRoot(IElement element) {
        return ((IElementImpl)element).hRoot();
    }

    public static <T> T getAncestor(IElement element, Class<T> ancestorType) {
        return ((IElementImpl)element).hAncestor(ancestorType);
    }

    public static IResource getResource(IElement element) {
        return ((IElementImpl)element).hResource();
    }

    public static IPath getPath(IElement element) {
        return ((IElementImpl)element).hPath();
    }

    public static boolean exists(IElement element) {
        return ((IElementImpl)element).hExists();
    }

    public static IElement[] getChildren(IElement element) throws CoreException {
        return ((IElementImpl)element).hChildren();
    }

    public static <T> T[] getChildren(IElement element, Class<T> childType) throws CoreException {
        return ((IElementImpl)element).hChildren(childType);
    }

    public static String toString(IElement element, ToStringStyle style) {
        return ((IElementImpl)element).hToString(style);
    }

    public static boolean equalsAndSameParent(IElement e1, IElement e2) {
        if (!e1.equals(e2)) {
            return false;
        }
        return Objects.equals(Elements.getParent(e1), Elements.getParent(e2));
    }

    public static ISourceElement getSourceElementAt(ISourceElement context, int position, ISnapshot base) throws CoreException {
        return ((ISourceElementImpl)context).hSourceElementAt(position, base);
    }

    public static ISourceElement getSourceElementAt2(ISourceElement context, int position, ISnapshot base) {
        try {
            return Elements.getSourceElementAt(context, position, base);
        }
        catch (CoreException e) {
            if (Elements.exists(context)) {
                Activator.log(e.getStatus());
            }
        }
        catch (StaleSnapshotException staleSnapshotException) {
            // empty catch block
        }
        return null;
    }

    public static ISourceElementInfo getSourceElementInfo(ISourceElement element) throws CoreException {
        return ((ISourceElementImpl)element).hSourceElementInfo();
    }

    public static ISourceElementInfo getSourceElementInfo2(ISourceElement element) {
        try {
            return Elements.getSourceElementInfo(element);
        }
        catch (CoreException e) {
            if (Elements.exists(element)) {
                Activator.log(e.getStatus());
            }
            return NO_SOURCE_INFO;
        }
    }

    public static ISourceFile getSourceFile(ISourceElement element) {
        if (element instanceof ISourceFile) {
            return (ISourceFile)element;
        }
        return Elements.getAncestor(element, ISourceFile.class);
    }

    public static boolean ensureReconciled(ISourceElement element, IProgressMonitor monitor) {
        ISourceFile sourceFile = Elements.getSourceFile(element);
        if (sourceFile != null) {
            try {
                Elements.reconcile(sourceFile, false, monitor);
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
                return false;
            }
        }
        return true;
    }

    public static IFile getFile(ISourceFile sourceFile) {
        return ((ISourceFileImpl)sourceFile).hFile();
    }

    public static boolean isWorkingCopy(ISourceFile sourceFile) {
        return ((ISourceFileImpl)sourceFile).hIsWorkingCopy();
    }

    public static boolean needsReconciling(ISourceFile sourceFile) {
        return ((ISourceFileImpl)sourceFile).hNeedsReconciling();
    }

    public static void reconcile(ISourceFile sourceFile, boolean force, IProgressMonitor monitor) throws CoreException {
        ((ISourceFileImpl)sourceFile).hReconcile(force, monitor);
    }

    public static IBuffer getBuffer(ISourceFile sourceFile) throws CoreException {
        return ((ISourceFileImpl)sourceFile).hBuffer();
    }

    public static IBuffer getBuffer(ISourceFile sourceFile, boolean create, IProgressMonitor monitor) throws CoreException {
        return ((ISourceFileImpl)sourceFile).hBuffer(create, monitor);
    }

    private Elements() {
    }
}

